/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.Layer;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.plots.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlotBuilderModel {
    private DefaultListModel listModel = new DefaultListModel();

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(DefaultListModel defaultListModel) {
        this.listModel = defaultListModel;
    }

    public Object clone() {
        PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            PlottingElement plottingElement = (PlottingElement)this.listModel.get(i);
            plotBuilderModel.listModel.addElement(plottingElement.clone());
        }
        return plotBuilderModel;
    }

    public boolean isValidAddition(ElementModel elementModel) {
        return true;
    }

    public String getCall() {
        PlottingElement plottingElement;
        int n;
        String string = "";
        string = string + "ggplot()";
        boolean bl = false;
        for (n = 0; n < this.listModel.getSize(); ++n) {
            plottingElement = (PlottingElement)this.listModel.get(n);
            if (!plottingElement.getModel().getType().equals("layer") && !plottingElement.getModel().getType().equals("template")) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        for (n = 0; n < this.listModel.getSize(); ++n) {
            String string2;
            plottingElement = (PlottingElement)this.listModel.get(n);
            if (!plottingElement.isActive() || (string2 = plottingElement.getModel().getCall()) == null || string2.length() <= 0 || string2.equals("null")) continue;
            string = string + " +\n\t" + string2;
        }
        return string;
    }

    public void tryToFillRequiredAess(Layer layer) {
        Vector vector = layer.aess;
        for (int i = 0; i < vector.size(); ++i) {
            Aes aes = (Aes)vector.get(i);
            if (!aes.required || aes.variable != null && aes.variable.length() != 0 || aes.value != null) continue;
            for (int j = this.listModel.size() - 1; j >= 0; --j) {
                PlottingElement plottingElement;
                ElementModel elementModel;
                if (aes.variable != null && aes.variable.length() > 0 || !((elementModel = (plottingElement = (PlottingElement)this.listModel.get(j)).getModel()) instanceof Layer)) continue;
                Vector vector2 = ((Layer)elementModel).aess;
                if (layer.data != null && !layer.data.equals(((Layer)elementModel).data)) continue;
                for (int k = 0; k < vector2.size(); ++k) {
                    Aes aes2 = (Aes)vector2.get(k);
                    if (!aes2.name.equals(aes.name) || aes2.variable == null || aes2.variable.length() <= 0 || aes2.variable.startsWith("..")) continue;
                    aes.variable = aes2.variable;
                    layer.data = ((Layer)elementModel).data;
                }
            }
        }
    }

    public String[] getAes() {
        String[] stringArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.listModel.size(); ++i) {
            Object object;
            int n;
            Vector vector;
            stringArray = (String[])this.listModel.get(i);
            ElementModel elementModel = stringArray.getModel();
            if (elementModel instanceof Layer) {
                vector = ((Layer)elementModel).aess;
                for (n = 0; n < vector.size(); ++n) {
                    object = (Aes)vector.get(n);
                    if (((Aes)object).variable == null || ((Aes)object).variable.length() <= 0) continue;
                    treeSet.add(((Aes)object).name);
                }
                continue;
            }
            if (!(elementModel instanceof Template)) continue;
            vector = ((Template)elementModel).getMAess();
            for (n = 0; n < vector.size(); ++n) {
                object = (Template.MaskingAes)vector.get(n);
                treeSet.add(((Template.MaskingAes)object).name);
            }
        }
        Object[] objectArray = treeSet.toArray();
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("PlottingBuilderModel");
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                Element element2 = ((PlottingElement)this.listModel.get(i)).toXML();
                element2 = (Element)document.importNode(element2, true);
                element.appendChild(element2);
            }
            element.setAttribute("className", "org.rosuda.deducer.plots.PlotBuilderModel");
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.PlotBuilderModel")) {
            System.out.println("Error PlotBuilderModel: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        try {
            this.listModel = new DefaultListModel();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("className");
                PlottingElement plottingElement = (PlottingElement)Class.forName(string2).newInstance();
                plottingElement.setFromXML(element2);
                this.listModel.addElement(plottingElement);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveToFile(File file, boolean bl) {
        Element element = this.toXML();
        Document document = element.getOwnerDocument();
        try {
            Object object;
            Object object2;
            Object object3;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            String string2 = file.getParent();
            File file2 = new File(string2, "tmp_plot_dir");
            file2.mkdir();
            File file3 = new File(file2.getPath(), "plot.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.close();
            fileOutputStream.close();
            stringWriter.close();
            if (bl) {
                object3 = new Vector();
                for (int i = 0; i < this.listModel.size(); ++i) {
                    object2 = (PlottingElement)this.listModel.get(i);
                    object = ((PlottingElement)object2).getModel();
                    if (object.getData() == null || ((Vector)object3).contains(object.getData())) continue;
                    ((Vector)object3).add(object.getData());
                }
                if (((Vector)object3).size() > 0) {
                    String string3 = Deducer.makeRCollection((Collection)object3, "c", true);
                    object2 = file2.getAbsolutePath() + "/data.RData";
                    if (System.getProperties().getProperty("file.separator").equals("\"")) {
                        ((String)object2).replace('\\', '/');
                    }
                    object = "save(list=" + string3 + ",file=\"" + Deducer.addSlashes((String)object2) + "\")";
                    Deducer.timedEval((String)object);
                }
            }
            object3 = new byte[18024];
            FileOutputStream fileOutputStream2 = new FileOutputStream(file);
            object2 = new ZipOutputStream(fileOutputStream2);
            object = file2.listFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                int n;
                FileInputStream fileInputStream = new FileInputStream((File)object[i]);
                ((ZipOutputStream)object2).putNextEntry(new ZipEntry(((File)object[i]).getName()));
                while ((n = fileInputStream.read((byte[])object3)) > 0) {
                    ((ZipOutputStream)object2).write((byte[])object3, 0, n);
                }
                ((ZipOutputStream)object2).closeEntry();
                fileInputStream.close();
                ((File)object[i]).delete();
            }
            ((ZipOutputStream)object2).close();
            fileOutputStream2.close();
            file2.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFromFile(File file) {
        try {
            int n;
            Object object;
            Object object2;
            BufferedOutputStream bufferedOutputStream;
            FileOutputStream fileOutputStream;
            BufferedInputStream bufferedInputStream;
            int n2 = 2048;
            String string = "data.RData";
            String string2 = "plot.xml";
            String string3 = file.getParent();
            File file2 = new File(string3, "tmp_plot_dir");
            file2.mkdir();
            File file3 = new File(file2.getPath(), string2);
            File file4 = new File(file2.getPath(), string);
            ZipFile zipFile = new ZipFile(file, 1);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                int n3;
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[n2];
                fileOutputStream = new FileOutputStream(file4);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n2);
                while ((n3 = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n3);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
                fileOutputStream.close();
                object2 = file4.getAbsolutePath();
                if (System.getProperties().getProperty("file.separator").equals("\"")) {
                    ((String)object2).replace('\\', '/');
                }
                object = "load(\"" + Deducer.addSlashes((String)object2) + "\")";
                System.out.println("\nNote: loading data from " + file.getName() + "\n");
                Deducer.timedEval((String)object);
                file4.delete();
            }
            zipEntry = zipFile.getEntry(string2);
            bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            byte[] byArray = new byte[n2];
            fileOutputStream = new FileOutputStream(file3);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n2);
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            fileOutputStream.close();
            this.listModel.removeAllElements();
            object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse(file3);
            Element element = (Element)object.getChildNodes().item(0);
            this.setFromXML(element);
            file3.delete();
            file2.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

