/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class FirstOrderFiniteDifferenceTransform
extends Transform.MultivariateTransform
implements Reportable {
    private final Transform.UnivariableTransform incrementTransform;
    public static final String NAME = "firstOrderFiniteDifferenceTransform";
    public static final String INCREMENT_TRANSFORM = "type";
    public static final String DIMENSION = "dim";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("dim", false), AttributeRule.newStringRule("type", true, "The transformation on the increments.")};

        @Override
        public String getParserName() {
            return FirstOrderFiniteDifferenceTransform.NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Transform.UnivariableTransform univariableTransform;
            double d = xMLObject.getAttribute("upper", 1.0);
            double d2 = xMLObject.getAttribute("lower", 0.0);
            String string = xMLObject.getAttribute(FirstOrderFiniteDifferenceTransform.INCREMENT_TRANSFORM, "none");
            if (string.equalsIgnoreCase("none")) {
                univariableTransform = new Transform.NoTransform();
            } else if (string.equalsIgnoreCase("log")) {
                univariableTransform = new Transform.LogTransform();
            } else if (string.equalsIgnoreCase("logit")) {
                univariableTransform = new Transform.ScaledLogitTransform(d2, d);
            } else {
                throw new RuntimeException("Invalid option for type");
            }
            int n = xMLObject.getIntegerAttribute(FirstOrderFiniteDifferenceTransform.DIMENSION);
            return new FirstOrderFiniteDifferenceTransform(n, univariableTransform);
        }

        @Override
        public String getParserDescription() {
            return "For vector X, creates new vector Y with Y[0] = incrementTransform(X[0]), Y[i] = incrementTransform(X[i]) - incrementTransform(X[i - i]).";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return Transform.MultivariateTransform.class;
        }
    };

    @Override
    public String getReport() {
        return null;
    }

    public FirstOrderFiniteDifferenceTransform(int n, Transform.UnivariableTransform univariableTransform) {
        super(n);
        this.incrementTransform = univariableTransform;
    }

    @Override
    protected double[] transform(double[] dArray) {
        double[] dArray2 = this.incrementTransform.transform(dArray, 0, this.dim);
        double[] dArray3 = new double[dArray.length];
        dArray3[0] = dArray2[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray3[i] = dArray2[i] - dArray2[i - 1];
        }
        return dArray3;
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[][] updateHessianLogDensity(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientInverseUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public double[] updateGradientUnWeightedLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double[] inverse(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = this.incrementTransform.inverse(dArray[0]);
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i] = this.incrementTransform.inverse(d += dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        return this.incrementTransform.isInInteriorDomain(dArray, 0, this.dim);
    }

    @Override
    public String getTransformName() {
        return "firstOrderFiniteDifference";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[this.dim];
        double[] dArray4 = this.transform(dArray2);
        double[] dArray5 = new double[this.dim];
        double d = 0.0;
        for (n = 0; n < this.dim; ++n) {
            dArray5[n] = this.incrementTransform.gradientInverse(d += dArray4[n]);
        }
        dArray3[this.dim - 1] = dArray[this.dim - 1] * dArray5[this.dim - 1];
        for (n = this.dim - 2; n > -1; --n) {
            dArray3[n] = dArray[n] * dArray5[n] + dArray3[n + 1];
        }
        double[] dArray6 = this.getGradientLogJacobianInverse(dArray4);
        for (int i = this.dim - 1; i > -1; --i) {
            int n2 = i;
            dArray3[n2] = dArray3[n2] + dArray6[i];
        }
        return dArray3;
    }

    @Override
    public double getLogJacobian(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.log(this.incrementTransform.derivativeOfTransformWrtValue(dArray[i]));
        }
        return d;
    }

    @Override
    public double[] getGradientLogJacobianInverse(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        double[] dArray3 = new double[this.dim];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = d += dArray[i];
            dArray2[i] = this.incrementTransform.logGradientInverse(d);
        }
        double[] dArray4 = new double[dArray.length];
        double d2 = 0.0;
        for (int i = dArray.length - 1; i > -1; --i) {
            dArray4[i] = d2 += Math.exp(-dArray2[i] + this.incrementTransform.logSecondDerivativeOfInverseTransformWrtValue(dArray3[i]));
        }
        return dArray4;
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += dArray[i];
            for (int j = 0; j < i + 1; ++j) {
                dArray2[j][i] = this.incrementTransform.gradientInverse(d);
            }
        }
        return dArray2;
    }
}

