## missoNet: News and Changes

### 1.5.1 — 2025-09-01

> **Major release.** Architecture rebuilt for speed, stability, and cleaner workflows. **Recommend all users upgrade.**

#### Highlights

- **3–5× faster** on typical problems via rewriting core kernels in **RcppArmadillo**.
- **Adaptive grid and lambda search** that scales to large problems with fewer evaluations.
- **Element-wise precise penalty control** for both coefficients and network edges.

#### Algorithm & Features

- Consistent search strategy in `missoNet()` and `cv.missoNet()`.
- **penalty customization** through `beta.pen.factor` and `theta.pen.factor`, enabling exclusion of predictors or structured sparsity patterns.
- `relax.net` option for **de-biased network estimation**: refits the active edge set without L1 penalties to reduce bias in the precision matrix.
- Support multiple graphical lasso backends (e.g., glassoFast (default) / glasso) with automatic selection and fallbacks.
- Smarter defaults and **data-aware initialization** tuned to dimensionality, missingness, and conditioning.
- **Full parallelization** for cross-validation and grid evaluation.

#### Performance & Robustness

- Vectorized algebra and memory reuse; internal benchmarks show **3–5× speedups**
- The **warm-start** strategy has been rewritten to enhance stability.
- Tighter line search and stopping in FISTA; **fewer oscillations**.
- Epsilon‑safe numerics; strict finite‑value checks.

#### Visualization & UX

- **Upgraded** S3 `plot()` for publication-quality output.
- Clearer progress and diagnostics (stages, backend, convergence).

#### Documentation

- **New vignettes: introduction, advanced features, case studies**.
- Cross-references and examples aligned across `missoNet()` and `cv.missoNet()`; arguments and return values documented consistently.

#### Bug Fixes

- Fixed `Inf` propagation in preprocessing.
- Fixed cross-package reference linking.
- Removed unused external data to reduce package size.
- Miscellaneous bugs.

> **Compatibility:** Minor API changes; refined defaults. See `?missoNet`, `?cv.missoNet`.


### 1.2.0 — 2023-07-18

- More stable convergence in difficult edge cases; fewer premature stops.
- Improved initialization with better defaults.
- Removed `glmnet` dependency.
- Better diagnostics and messages.

### 1.1.0 — 2023-05-10

- Final evaluations are now based on **warm starts**.
- Tuned default parameters based on empirical testing across representative datasets.
- Dropped C++11 requirement.

### 1.0.0 — 2022-10-06

- Initial CRAN release.
