/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.math.MathUtils;
import java.util.ArrayList;

@Deprecated
public class SubtreeSlide {
    private double size = 1.0;
    private boolean gaussian = false;

    public SubtreeSlide(double d, boolean bl) {
        this.size = d;
        this.gaussian = bl;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public double slideSubtree(MutableTree mutableTree) {
        double d;
        NodeRef nodeRef;
        do {
            nodeRef = mutableTree.getNode(MathUtils.nextInt(mutableTree.getNodeCount()));
        } while (mutableTree.getRoot() == nodeRef);
        NodeRef nodeRef2 = mutableTree.getParent(nodeRef);
        NodeRef nodeRef3 = this.getOtherChild(mutableTree, nodeRef2, nodeRef);
        NodeRef nodeRef4 = mutableTree.getParent(nodeRef2);
        double d2 = this.getDelta();
        double d3 = mutableTree.getNodeHeight(nodeRef2);
        double d4 = d3 + d2;
        if (d2 > 0.0) {
            if (nodeRef4 != null && mutableTree.getNodeHeight(nodeRef4) < d4) {
                NodeRef nodeRef5 = nodeRef4;
                NodeRef nodeRef6 = nodeRef2;
                while (mutableTree.getNodeHeight(nodeRef5) < d4) {
                    nodeRef6 = nodeRef5;
                    if ((nodeRef5 = mutableTree.getParent(nodeRef5)) != null) continue;
                }
                mutableTree.beginTreeEdit();
                if (mutableTree.isRoot(nodeRef6)) {
                    mutableTree.removeChild(nodeRef2, nodeRef3);
                    mutableTree.removeChild(nodeRef4, nodeRef2);
                    mutableTree.addChild(nodeRef2, nodeRef6);
                    mutableTree.addChild(nodeRef4, nodeRef3);
                    mutableTree.setRoot(nodeRef2);
                } else {
                    mutableTree.removeChild(nodeRef2, nodeRef3);
                    mutableTree.removeChild(nodeRef4, nodeRef2);
                    mutableTree.removeChild(nodeRef5, nodeRef6);
                    mutableTree.addChild(nodeRef2, nodeRef6);
                    mutableTree.addChild(nodeRef4, nodeRef3);
                    mutableTree.addChild(nodeRef5, nodeRef2);
                }
                mutableTree.setNodeHeight(nodeRef2, d4);
                mutableTree.endTreeEdit();
                int n = this.intersectingEdges(mutableTree, nodeRef6, d3, null);
                d = Math.log(1.0 / (double)n);
            } else {
                mutableTree.setNodeHeight(nodeRef2, d4);
                d = 0.0;
            }
        } else {
            if (mutableTree.getNodeHeight(nodeRef) > d4) {
                return Double.NEGATIVE_INFINITY;
            }
            if (mutableTree.getNodeHeight(nodeRef3) > d4) {
                ArrayList arrayList = new ArrayList();
                int n = this.intersectingEdges(mutableTree, nodeRef3, d4, arrayList);
                if (arrayList.size() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n2 = MathUtils.nextInt(arrayList.size());
                NodeRef nodeRef7 = (NodeRef)arrayList.get(n2);
                NodeRef nodeRef8 = mutableTree.getParent(nodeRef7);
                mutableTree.beginTreeEdit();
                if (mutableTree.isRoot(nodeRef2)) {
                    mutableTree.removeChild(nodeRef2, nodeRef3);
                    mutableTree.removeChild(nodeRef8, nodeRef7);
                    mutableTree.addChild(nodeRef2, nodeRef7);
                    mutableTree.addChild(nodeRef8, nodeRef2);
                    mutableTree.setRoot(nodeRef3);
                } else {
                    mutableTree.removeChild(nodeRef2, nodeRef3);
                    mutableTree.removeChild(nodeRef4, nodeRef2);
                    mutableTree.removeChild(nodeRef8, nodeRef7);
                    mutableTree.addChild(nodeRef2, nodeRef7);
                    mutableTree.addChild(nodeRef4, nodeRef3);
                    mutableTree.addChild(nodeRef8, nodeRef2);
                }
                mutableTree.setNodeHeight(nodeRef2, d4);
                mutableTree.endTreeEdit();
                d = Math.log(n);
            } else {
                mutableTree.setNodeHeight(nodeRef2, d4);
                d = 0.0;
            }
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private int intersectingEdges(Tree tree, NodeRef nodeRef, double d, ArrayList arrayList) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (tree.getNodeHeight(nodeRef) < d) {
            if (arrayList != null) {
                arrayList.add(nodeRef);
            }
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += this.intersectingEdges(tree, tree.getChild(nodeRef, i), d, arrayList);
        }
        return n;
    }

    private NodeRef getOtherChild(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        if (tree.getChild(nodeRef, 0) == nodeRef2) {
            return tree.getChild(nodeRef, 1);
        }
        return tree.getChild(nodeRef, 0);
    }
}

