/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import beagle.Beagle;
import beagle.BeagleBenchmarkFlag;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import dr.evolution.alignment.AscertainedSitePatterns;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.UncertainSiteList;
import dr.evolution.datatype.HiddenDataType;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.MarkovModulatedSubstitutionModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.BeagleFunctionality;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treelikelihood.AbstractSinglePartitionTreeLikelihood;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.evomodel.treelikelihood.SubstitutionModelDelegate;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.ThreadAwareLikelihood;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

@Deprecated
public class BeagleTreeLikelihood
extends AbstractSinglePartitionTreeLikelihood
implements ThreadAwareLikelihood {
    private static final String RESOURCE_AUTO_PROPERTY = "beagle.resource.auto";
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final String DELAY_SCALING_PROPERTY = "beagle.delay.scaling";
    private static final String EXTRA_BUFFER_COUNT_PROPERTY = "beagle.extra.buffer.count";
    private static final String FORCE_VECTORIZATION = "beagle.force.vectorization";
    private static final String THREAD_COUNT = "beagle.thread.count";
    private static final PartialsRescalingScheme DEFAULT_RESCALING_SCHEME = PartialsRescalingScheme.DYNAMIC;
    private static List<Integer> resourceOrder = null;
    private static List<Integer> preferredOrder = null;
    private static List<Integer> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static List<Integer> extraBufferOrder = null;
    private static final int RESCALE_FREQUENCY = 100;
    private static final int RESCALE_TIMES = 1;
    private static final boolean RESCALING_OFF = false;
    private static final boolean DEBUG = false;
    private int[] branchUpdateIndices;
    private double[] branchLengths;
    private int branchUpdateCount;
    private int[] scaleBufferIndices;
    private int[] storedScaleBufferIndices;
    private int[][] operations;
    private int operationListCount;
    private int[] operationCount;
    private static final boolean hasRestrictedPartials = false;
    private final int numRestrictedPartials;
    private final Map<Set<String>, Parameter> partialsRestrictions;
    private Parameter[] partialsMap;
    private double[] partials;
    private boolean updateRestrictedNodePartials;
    protected BufferIndexHelper partialBufferHelper;
    protected BufferIndexHelper scaleBufferHelper;
    protected final int tipCount;
    protected final int internalNodeCount;
    private PartialsRescalingScheme rescalingScheme;
    private int rescalingFrequency = 100;
    private boolean delayRescalingUntilUnderflow = true;
    protected boolean useScaleFactors = false;
    private boolean useAutoScaling = false;
    private boolean recomputeScaleFactors = false;
    private boolean everUnderflowed = false;
    private int rescalingCount = 0;
    private int rescalingCountInner = 0;
    private int rescalingMessageCount = 0;
    private int threadCount = -1;
    protected final BranchModel branchModel;
    protected final SubstitutionModelDelegate substitutionModelDelegate;
    protected final SiteRateModel siteRateModel;
    protected final BranchRateModel branchRateModel;
    private final TipStatesModel tipStatesModel;
    protected double[] patternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] tipPartials;
    protected int[] tipStates;
    protected Beagle beagle;
    protected boolean updateSubstitutionModel;
    protected boolean updateSiteModel;
    private boolean ascertainedSitePatterns = false;
    protected final boolean useAmbiguities;

    public BeagleTreeLikelihood(PatternList patternList, TreeModel treeModel, BranchModel branchModel, SiteRateModel siteRateModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, PartialsRescalingScheme partialsRescalingScheme, boolean bl2) {
        this(patternList, treeModel, branchModel, siteRateModel, branchRateModel, tipStatesModel, bl, partialsRescalingScheme, bl2, null);
    }

    public BeagleTreeLikelihood(PatternList patternList, MutableTreeModel mutableTreeModel, BranchModel branchModel, SiteRateModel siteRateModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, PartialsRescalingScheme partialsRescalingScheme, boolean bl2, Map<Set<String>, Parameter> map) {
        super("treeLikelihood", patternList, mutableTreeModel);
        try {
            Object object;
            Object object2;
            String string;
            int n;
            String string2;
            int n2;
            String string3;
            String string4;
            Logger logger = Logger.getLogger("dr.evomodel");
            logger.info("\nUsing BEAGLE TreeLikelihood");
            this.siteRateModel = siteRateModel;
            this.addModel(this.siteRateModel);
            this.branchModel = branchModel;
            this.addModel(this.branchModel);
            if (branchRateModel != null) {
                this.branchRateModel = branchRateModel;
                logger.info("  Branch rate model used: " + branchRateModel.getModelName());
            } else {
                this.branchRateModel = new DefaultBranchRateModel();
            }
            this.addModel(this.branchRateModel);
            if (patternList instanceof UncertainSiteList || patternList.getDataType() instanceof HiddenDataType) {
                bl = true;
            }
            this.tipStatesModel = tipStatesModel;
            this.categoryCount = this.siteRateModel.getCategoryCount();
            this.tipCount = mutableTreeModel.getExternalNodeCount();
            this.internalNodeCount = this.nodeCount - this.tipCount;
            int n3 = this.tipCount;
            if (bl) {
                n3 = 0;
            }
            this.partialBufferHelper = new BufferIndexHelper(this.nodeCount, this.tipCount);
            this.scaleBufferHelper = new BufferIndexHelper(this.getScaleBufferCount(), 0);
            if (resourceOrder == null) {
                resourceOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
            }
            if (preferredOrder == null) {
                preferredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(PREFERRED_FLAGS_PROPERTY);
            }
            if (requiredOrder == null) {
                requiredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(REQUIRED_FLAGS_PROPERTY);
            }
            if (scalingOrder == null) {
                scalingOrder = BeagleFunctionality.parseSystemPropertyStringArray(SCALING_PROPERTY);
            }
            if (extraBufferOrder == null) {
                extraBufferOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(EXTRA_BUFFER_COUNT_PROPERTY);
            }
            int n4 = -1;
            if (extraBufferOrder.size() > 0) {
                n4 = extraBufferOrder.get(BeagleDataLikelihoodDelegate.instanceCount % extraBufferOrder.size());
            }
            this.substitutionModelDelegate = new SubstitutionModelDelegate(mutableTreeModel, branchModel, n4);
            this.rescalingScheme = partialsRescalingScheme;
            this.delayRescalingUntilUnderflow = bl2;
            int[] nArray = null;
            long l = 0L;
            long l2 = 0L;
            if (scalingOrder.size() > 0) {
                this.rescalingScheme = PartialsRescalingScheme.parseFromString(scalingOrder.get(BeagleDataLikelihoodDelegate.instanceCount % scalingOrder.size()));
            }
            if (resourceOrder.size() > 0 && (nArray = new int[]{resourceOrder.get(BeagleDataLikelihoodDelegate.instanceCount % resourceOrder.size()), 0})[0] > 0) {
                l |= BeagleFlag.PROCESSOR_GPU.getMask();
            }
            if (preferredOrder.size() > 0) {
                l = preferredOrder.get(BeagleDataLikelihoodDelegate.instanceCount % preferredOrder.size()).intValue();
            }
            if (requiredOrder.size() > 0) {
                l2 = requiredOrder.get(BeagleDataLikelihoodDelegate.instanceCount % requiredOrder.size()).intValue();
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DEFAULT) {
                this.rescalingScheme = nArray != null && nArray[0] > true ? DEFAULT_RESCALING_SCHEME : DEFAULT_RESCALING_SCHEME;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                this.delayRescalingUntilUnderflow = true;
                this.rescalingScheme = PartialsRescalingScheme.ALWAYS;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
                l |= BeagleFlag.SCALING_AUTO.getMask();
                this.useAutoScaling = true;
            }
            if ((string4 = System.getProperty(RESCALE_FREQUENCY_PROPERTY)) != null) {
                this.rescalingFrequency = Integer.parseInt(string4);
                if (this.rescalingFrequency < 1) {
                    this.rescalingFrequency = 100;
                }
            }
            if ((string3 = System.getProperty(DELAY_SCALING_PROPERTY)) != null) {
                this.delayRescalingUntilUnderflow = Boolean.parseBoolean(string3);
            }
            for (n2 = 0; n2 < this.substitutionModelDelegate.getSubstitutionModelCount(); ++n2) {
                if (!(this.substitutionModelDelegate.getSubstitutionModel(n2) instanceof MarkovModulatedSubstitutionModel)) continue;
                this.rescalingScheme = PartialsRescalingScheme.ALWAYS;
                this.delayRescalingUntilUnderflow = false;
            }
            if (l == 0L && nArray == null && this.stateCount == 4 && patternList.getPatternCount() < 10000) {
                l |= BeagleFlag.PROCESSOR_CPU.getMask();
            }
            n2 = 0;
            String string5 = System.getProperty(FORCE_VECTORIZATION);
            if (string5 != null) {
                n2 = 1;
            }
            if ((string2 = System.getProperty(THREAD_COUNT)) != null) {
                this.threadCount = Integer.parseInt(string2);
            }
            if (this.threadCount == 0 || this.threadCount == 1) {
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_NONE.getMask();
            } else {
                l &= BeagleFlag.THREADING_NONE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.THREADING_CPP.getMask();
            }
            if (BeagleFlag.VECTOR_SSE.isSet(l) && this.stateCount != 4 && n2 == 0 && !BeagleFunctionality.IS_ODD_STATE_SSE_FIXED()) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.VECTOR_NONE.getMask();
                if (this.stateCount > 4 && this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                    this.rescalingScheme = PartialsRescalingScheme.DELAYED;
                }
            }
            if (!BeagleFlag.PRECISION_SINGLE.isSet(l)) {
                l |= BeagleFlag.PRECISION_DOUBLE.getMask();
            }
            if (this.substitutionModelDelegate.canReturnComplexDiagonalization()) {
                l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
            }
            if (this.stateCount != (n = branchModel.getRootFrequencyModel().getFrequencyCount())) {
                throw new RuntimeException("Pattern state count (" + this.stateCount + ") does not match substitution model state count (" + n + ")");
            }
            if (nArray == null && (BeagleFlag.PROCESSOR_GPU.isSet(l) || BeagleFlag.FRAMEWORK_CUDA.isSet(l) || BeagleFlag.FRAMEWORK_OPENCL.isSet(l)) || nArray != null && nArray[0] > 0) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((string = System.getProperty(RESOURCE_AUTO_PROPERTY)) != null && Boolean.parseBoolean(string)) {
                long l3 = 0L;
                l3 = this.rescalingScheme == PartialsRescalingScheme.NONE ? BeagleBenchmarkFlag.SCALING_NONE.getMask() : (this.rescalingScheme == PartialsRescalingScheme.ALWAYS ? BeagleBenchmarkFlag.SCALING_ALWAYS.getMask() : BeagleBenchmarkFlag.SCALING_DYNAMIC.getMask());
                logger.info("\nRunning benchmarks to automatically select fastest BEAGLE resource for  analysis or partition... ");
                object2 = BeagleFactory.getBenchmarkedResourceDetails(this.tipCount, n3, this.stateCount, this.patternCount, this.categoryCount, nArray, l, l2, 1, 1, 0, l3);
                logger.info(" Benchmark results, from fastest to slowest:");
                object = object2.iterator();
                while (object.hasNext()) {
                    String[] stringArray = object.next();
                    logger.info(stringArray.toString());
                }
                nArray = new int[]{object2.get(0).getResourceNumber()};
            }
            ++BeagleDataLikelihoodDelegate.instanceCount;
            this.beagle = BeagleFactory.loadBeagleInstance(this.tipCount, this.partialBufferHelper.getBufferCount(), n3, this.stateCount, this.patternCount, this.substitutionModelDelegate.getEigenBufferCount(), this.substitutionModelDelegate.getMatrixBufferCount(), this.categoryCount, this.scaleBufferHelper.getBufferCount(), nArray, l, l2);
            InstanceDetails instanceDetails = this.beagle.getDetails();
            ResourceDetails resourceDetails = null;
            if (instanceDetails != null) {
                resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
                if (resourceDetails != null) {
                    object2 = new StringBuilder("  Using BEAGLE resource ");
                    ((StringBuilder)object2).append(resourceDetails.getNumber()).append(": ");
                    ((StringBuilder)object2).append(resourceDetails.getName()).append("\n");
                    if (resourceDetails.getDescription() != null) {
                        for (String string6 : object = resourceDetails.getDescription().split("\\|")) {
                            if (string6.trim().length() <= 0) continue;
                            ((StringBuilder)object2).append("    ").append(string6.trim()).append("\n");
                        }
                    }
                    ((StringBuilder)object2).append("    with instance flags: ").append(instanceDetails.toString());
                    logger.info(((StringBuilder)object2).toString());
                } else {
                    logger.info("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
                }
            } else {
                logger.info("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
            }
            if (BeagleFunctionality.IS_THREAD_COUNT_COMPATIBLE()) {
                if (this.threadCount > 0) {
                    this.beagle.setCPUThreadCount(this.threadCount);
                } else {
                    this.beagle.setCPUThreadCount(Integer.MAX_VALUE);
                }
            }
            logger.info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            logger.info("  With " + patternList.getPatternCount() + " unique site patterns.");
            if (tipStatesModel != null) {
                tipStatesModel.setTree(mutableTreeModel);
                if (tipStatesModel.getModelType() == TipStatesModel.Type.PARTIALS) {
                    this.tipPartials = new double[this.patternCount * this.stateCount];
                } else {
                    this.tipStates = new int[this.patternCount];
                }
                this.addModel(tipStatesModel);
            }
            for (int i = 0; i < this.tipCount; ++i) {
                object = mutableTreeModel.getTaxonId(i);
                int n5 = patternList.getTaxonIndex((String)object);
                if (n5 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + (String)object + ", in tree, " + mutableTreeModel.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (tipStatesModel != null) {
                    tipStatesModel.setStates(patternList, n5, i, (String)object);
                    if (tipStatesModel.getModelType() == TipStatesModel.Type.PARTIALS) {
                        this.setPartials(this.beagle, tipStatesModel, i);
                        continue;
                    }
                    tipStatesModel.getTipStates(i, this.tipStates);
                    this.beagle.setTipStates(i, this.tipStates);
                    continue;
                }
                if (bl) {
                    this.setPartials(this.beagle, patternList, n5, i);
                    continue;
                }
                this.setStates(this.beagle, patternList, n5, i);
            }
            if (patternList instanceof AscertainedSitePatterns) {
                this.ascertainedSitePatterns = true;
            }
            this.partialsRestrictions = map;
            this.numRestrictedPartials = 0;
            this.updateRestrictedNodePartials = false;
            this.beagle.setPatternWeights(this.patternWeights);
            String string7 = "  Using rescaling scheme : " + this.rescalingScheme.getText();
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO && resourceDetails != null && (resourceDetails.getFlags() & BeagleFlag.SCALING_AUTO.getMask()) == 0L) {
                this.rescalingScheme = PartialsRescalingScheme.DYNAMIC;
                string7 = "  Auto rescaling not supported in BEAGLE, using : " + this.rescalingScheme.getText();
            }
            boolean bl3 = false;
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                string7 = string7 + " (rescaling every " + this.rescalingFrequency + " evaluations";
                bl3 = true;
            }
            if (this.delayRescalingUntilUnderflow) {
                string7 = string7 + (bl3 ? ", " : " (") + "delay rescaling until first overflow";
                bl3 = true;
            }
            string7 = string7 + (bl3 ? ")" : "");
            logger.info(string7);
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                this.everUnderflowed = false;
            }
            this.updateSubstitutionModel = true;
            this.updateSiteModel = true;
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        this.useAmbiguities = bl;
        this.hasInitialized = true;
    }

    public TipStatesModel getTipStatesModel() {
        return this.tipStatesModel;
    }

    public PatternList getPatternsList() {
        return this.patternList;
    }

    public MutableTreeModel getTreeModel() {
        return this.treeModel;
    }

    public BranchModel getBranchModel() {
        return this.branchModel;
    }

    public SiteRateModel getSiteRateModel() {
        return this.siteRateModel;
    }

    public BranchRateModel getBranchRateModel() {
        return this.branchRateModel;
    }

    public PartialsRescalingScheme getRescalingScheme() {
        return this.rescalingScheme;
    }

    public boolean isDelayRescalingUntilUnderflow() {
        return this.delayRescalingUntilUnderflow;
    }

    public Map<Set<String>, Parameter> getPartialsRestrictions() {
        return this.partialsRestrictions;
    }

    public boolean useAmbiguities() {
        return this.useAmbiguities;
    }

    protected int getScaleBufferCount() {
        return this.internalNodeCount + 1;
    }

    protected final void setPartials(Beagle beagle, PatternList patternList, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        int n6 = 0;
        for (n5 = 0; n5 < this.patternCount; ++n5) {
            if (patternList instanceof UncertainSiteList) {
                ((UncertainSiteList)patternList).fillPartials(n, n5, dArray, n6);
                n6 += this.stateCount;
                continue;
            }
            n4 = patternList.getPatternState(n, n5);
            boolean[] blArray = this.dataType.getStateSet(n4);
            for (n3 = 0; n3 < this.stateCount; ++n3) {
                dArray[n6] = blArray[n3] ? 1.0 : 0.0;
                ++n6;
            }
        }
        n4 = n5 = this.patternCount * this.stateCount;
        for (n3 = 1; n3 < this.categoryCount; ++n3) {
            System.arraycopy(dArray, 0, dArray, n4, n5);
            n4 += n5;
        }
        beagle.setPartials(n2, dArray);
    }

    protected final void setPartials(Beagle beagle, TipStatesModel tipStatesModel, int n) {
        int n2;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        tipStatesModel.getTipPartials(n, dArray);
        int n3 = n2 = this.patternCount * this.stateCount;
        for (int i = 1; i < this.categoryCount; ++i) {
            System.arraycopy(dArray, 0, dArray, n3, n2);
            n3 += n2;
        }
        beagle.setPartials(n, dArray);
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    protected final void setStates(Beagle beagle, PatternList patternList, int n, int n2) {
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            nArray[i] = patternList.getPatternState(n, i);
        }
        beagle.setTipStates(n2, nArray);
    }

    public final void setPatternWeights(double[] dArray) {
        this.patternWeights = dArray;
        this.beagle.setPatternWeights(dArray);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                    this.updateRestrictedNodePartials = true;
                } else if (((TreeChangedEvent)object).isTreeChanged()) {
                    this.updateAllNodes();
                    this.updateRestrictedNodePartials = true;
                }
            }
        } else if (model == this.branchRateModel) {
            if (n == -1) {
                this.updateAllNodes();
            } else {
                this.updateNode(this.treeModel.getNode(n));
            }
        } else if (model == this.branchModel) {
            if (n == -1) {
                this.updateSubstitutionModel = true;
                this.updateAllNodes();
            } else {
                this.updateNode(this.treeModel.getNode(n));
            }
        } else if (model == this.siteRateModel) {
            this.updateSiteModel = true;
            this.updateAllNodes();
        } else if (model == this.tipStatesModel) {
            if (object instanceof Taxon) {
                for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                    if (this.treeModel.getNodeTaxon(this.treeModel.getNode(i)) == null || !this.treeModel.getNodeTaxon(this.treeModel.getNode(i)).getId().equalsIgnoreCase(((Taxon)object).getId())) continue;
                    this.updateNode(this.treeModel.getNode(i));
                }
            } else if (!(object instanceof Parameter)) {
                this.updateAllNodes();
            }
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        this.updateSiteModel = true;
        this.updateSubstitutionModel = true;
        this.updateRestrictedNodePartials = true;
    }

    @Override
    protected void storeState() {
        this.partialBufferHelper.storeState();
        this.substitutionModelDelegate.storeState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.storeState();
            System.arraycopy(this.scaleBufferIndices, 0, this.storedScaleBufferIndices, 0, this.scaleBufferIndices.length);
        }
        super.storeState();
    }

    @Override
    protected void restoreState() {
        this.updateSiteModel = true;
        this.partialBufferHelper.restoreState();
        this.substitutionModelDelegate.restoreState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.restoreState();
            int[] nArray = this.storedScaleBufferIndices;
            this.storedScaleBufferIndices = this.scaleBufferIndices;
            this.scaleBufferIndices = nArray;
        }
        this.updateRestrictedNodePartials = true;
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        double d;
        int n;
        boolean bl;
        int n2;
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (this.branchUpdateIndices == null) {
            this.branchUpdateIndices = new int[this.nodeCount];
            this.branchLengths = new double[this.nodeCount];
            this.scaleBufferIndices = new int[this.internalNodeCount];
            this.storedScaleBufferIndices = new int[this.internalNodeCount];
        }
        if (this.operations == null) {
            this.operations = new int[this.numRestrictedPartials + 1][this.internalNodeCount * 7];
            this.operationCount = new int[this.numRestrictedPartials + 1];
        }
        this.recomputeScaleFactors = false;
        if (!this.delayRescalingUntilUnderflow || this.everUnderflowed) {
            if (this.rescalingScheme == PartialsRescalingScheme.ALWAYS || this.rescalingScheme == PartialsRescalingScheme.DELAYED) {
                this.useScaleFactors = true;
                this.recomputeScaleFactors = true;
            } else if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                this.useScaleFactors = true;
                if (this.rescalingCount > this.rescalingFrequency) {
                    this.rescalingCount = 0;
                    this.rescalingCountInner = 0;
                }
                if (this.rescalingCountInner < 1) {
                    this.recomputeScaleFactors = true;
                    this.updateAllNodes();
                    ++this.rescalingCountInner;
                }
                ++this.rescalingCount;
            }
        }
        if (this.tipStatesModel != null) {
            int n3 = this.treeModel.getExternalNodeCount();
            for (n2 = 0; n2 < n3; ++n2) {
                if (!this.updateNode[n2]) continue;
                if (this.tipStatesModel.getModelType() == TipStatesModel.Type.PARTIALS) {
                    this.tipStatesModel.getTipPartials(n2, this.tipPartials);
                    this.beagle.setTipPartials(n2, this.tipPartials);
                    continue;
                }
                this.tipStatesModel.getTipStates(n2, this.tipStates);
                this.beagle.setTipStates(n2, this.tipStates);
            }
        }
        this.branchUpdateCount = 0;
        this.operationListCount = 0;
        this.operationCount[0] = 0;
        NodeRef nodeRef = this.treeModel.getRoot();
        this.traverse(this.treeModel, nodeRef, null, true);
        if (this.updateSubstitutionModel) {
            try {
                this.substitutionModelDelegate.updateSubstitutionModels(this.beagle);
            }
            catch (ArithmeticException arithmeticException) {
                Logger.getLogger("dr.evomodel").warning("Arithmetic exception: " + arithmeticException.getMessage());
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (this.updateSiteModel) {
            double[] dArray = this.siteRateModel.getCategoryRates();
            if (dArray == null) {
                return Double.NEGATIVE_INFINITY;
            }
            this.beagle.setCategoryRates(dArray);
        }
        if (this.branchUpdateCount > 0) {
            this.substitutionModelDelegate.updateTransitionMatrices(this.beagle, this.branchUpdateIndices, this.branchLengths, this.branchUpdateCount);
        }
        this.totalMatrixUpdateCount += this.branchUpdateCount;
        for (n2 = 0; n2 <= this.numRestrictedPartials; ++n2) {
            this.totalOperationCount += this.operationCount[n2];
        }
        boolean bl2 = true;
        do {
            this.beagle.updatePartials(this.operations[0], this.operationCount[0], -1);
            n = this.partialBufferHelper.getOffsetIndex(nodeRef.getNumber());
            double[] dArray = this.siteRateModel.getCategoryProportions();
            double[] dArray2 = this.substitutionModelDelegate.getRootStateFrequencies();
            int n4 = -1;
            if (this.useScaleFactors) {
                if (this.recomputeScaleFactors) {
                    this.scaleBufferHelper.flipOffset(this.internalNodeCount);
                    n4 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                    this.beagle.resetScaleFactors(n4);
                    this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, n4);
                } else {
                    n4 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                }
            } else if (this.useAutoScaling) {
                this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, -1);
            }
            this.beagle.setCategoryWeights(0, dArray);
            this.beagle.setStateFrequencies(0, dArray2);
            double[] dArray3 = new double[1];
            this.beagle.calculateRootLogLikelihoods(new int[]{n}, new int[]{0}, new int[]{0}, new int[]{n4}, 1, dArray3);
            d = dArray3[0];
            this.beagle.getSiteLogLikelihoods(this.patternLogLikelihoods);
            if (this.ascertainedSitePatterns) {
                this.beagle.getSiteLogLikelihoods(this.patternLogLikelihoods);
                d = this.getAscertainmentCorrectedLogLikelihood((AscertainedSitePatterns)this.patternList, this.patternLogLikelihoods, this.patternWeights);
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.everUnderflowed = true;
                d = Double.NEGATIVE_INFINITY;
                if (bl2 && (this.delayRescalingUntilUnderflow || this.rescalingScheme == PartialsRescalingScheme.DELAYED)) {
                    if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC || this.rescalingCount == 0) {
                        if (this.rescalingMessageCount % 1000 == 0) {
                            if (this.rescalingMessageCount > 0) {
                                Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood (" + this.rescalingMessageCount + " messages not shown).");
                            } else {
                                Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood. Attempting a rescaling...");
                            }
                        }
                        ++this.rescalingMessageCount;
                    }
                    this.useScaleFactors = true;
                    this.recomputeScaleFactors = true;
                    this.branchUpdateCount = 0;
                    this.updateAllNodes();
                    this.operationCount[0] = 0;
                    this.traverse(this.treeModel, nodeRef, null, false);
                    bl = false;
                    bl2 = false;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        } while (!bl);
        for (n = 0; n < this.nodeCount; ++n) {
            this.updateNode[n] = false;
        }
        this.updateSubstitutionModel = false;
        this.updateSiteModel = false;
        return d;
    }

    public void getPartials(int n, double[] dArray) {
        int n2 = -1;
        this.beagle.getPartials(this.partialBufferHelper.getOffsetIndex(n), n2, dArray);
    }

    public boolean arePartialsRescaled() {
        return this.useScaleFactors;
    }

    protected void setPartials(int n, double[] dArray) {
        this.beagle.setPartials(this.partialBufferHelper.getOffsetIndex(n), dArray);
    }

    private void restrictNodePartials(int n) {
        Parameter parameter = this.partialsMap[n];
        if (parameter == null) {
            return;
        }
        this.getPartials(n, this.partials);
        double[] dArray = parameter.getParameterValues();
        int n2 = this.stateCount * this.patternCount;
        if (dArray.length == n2) {
            for (int i = 0; i < this.categoryCount; ++i) {
                this.componentwiseMultiply(this.partials, n2 * i, dArray, 0, n2);
            }
        } else {
            this.componentwiseMultiply(this.partials, 0, dArray, 0, n2 * this.categoryCount);
        }
        this.setPartials(n, this.partials);
    }

    private void componentwiseMultiply(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = n + i;
            dArray[n4] = dArray[n4] * dArray2[n2 + i];
        }
    }

    private void computeNodeToRestrictionMap() {
        Arrays.fill(this.partialsMap, null);
        for (Set<String> set : this.partialsRestrictions.keySet()) {
            NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.treeModel, set);
            this.partialsMap[nodeRef.getNumber()] = this.partialsRestrictions.get(set);
        }
    }

    private double getAscertainmentCorrectedLogLikelihood(AscertainedSitePatterns ascertainedSitePatterns, double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = ascertainedSitePatterns.getAscertainmentCorrection(dArray);
        for (int i = 0; i < this.patternCount; ++i) {
            d += (dArray[i] - d2) * dArray2[i];
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverse(Tree tree, NodeRef nodeRef, int[] nArray, boolean bl) {
        boolean bl2 = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nArray != null) {
            nArray[0] = -1;
        }
        if (nodeRef2 != null && this.updateNode[n]) {
            double d;
            BranchRateModel branchRateModel = this.branchRateModel;
            synchronized (branchRateModel) {
                d = this.branchRateModel.getBranchRate(tree, nodeRef);
            }
            double d2 = tree.getNodeHeight(nodeRef2);
            double d3 = tree.getNodeHeight(nodeRef);
            double d4 = d * (d2 - d3);
            if (d4 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d4 + " (parent: " + nodeRef2 + "; height: " + d2 + " - child: " + nodeRef + " height: " + d3 + ")");
            }
            if (bl) {
                this.substitutionModelDelegate.flipMatrixBuffer(n);
            }
            this.branchUpdateIndices[this.branchUpdateCount] = n;
            this.branchLengths[this.branchUpdateCount] = d4;
            ++this.branchUpdateCount;
            bl2 = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            int[] nArray2 = new int[]{-1};
            boolean bl3 = this.traverse(tree, nodeRef3, nArray2, bl);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            int[] nArray3 = new int[]{-1};
            boolean bl4 = this.traverse(tree, nodeRef4, nArray3, bl);
            if (bl3 || bl4) {
                int n2 = this.operationCount[this.operationListCount] * 7;
                if (bl) {
                    this.partialBufferHelper.flipOffset(n);
                }
                int[] nArray4 = this.operations[this.operationListCount];
                nArray4[n2] = this.partialBufferHelper.getOffsetIndex(n);
                if (this.useScaleFactors) {
                    int n3 = n - this.tipCount;
                    if (this.recomputeScaleFactors) {
                        this.scaleBufferHelper.flipOffset(n3);
                        this.scaleBufferIndices[n3] = this.scaleBufferHelper.getOffsetIndex(n3);
                        nArray4[n2 + 1] = this.scaleBufferIndices[n3];
                        nArray4[n2 + 2] = -1;
                    } else {
                        nArray4[n2 + 1] = -1;
                        nArray4[n2 + 2] = this.scaleBufferIndices[n3];
                    }
                } else {
                    if (this.useAutoScaling) {
                        this.scaleBufferIndices[n - this.tipCount] = this.partialBufferHelper.getOffsetIndex(n);
                    }
                    nArray4[n2 + 1] = -1;
                    nArray4[n2 + 2] = -1;
                }
                nArray4[n2 + 3] = this.partialBufferHelper.getOffsetIndex(nodeRef3.getNumber());
                nArray4[n2 + 4] = this.substitutionModelDelegate.getMatrixIndex(nodeRef3.getNumber());
                nArray4[n2 + 5] = this.partialBufferHelper.getOffsetIndex(nodeRef4.getNumber());
                nArray4[n2 + 6] = this.substitutionModelDelegate.getMatrixIndex(nodeRef4.getNumber());
                int n4 = this.operationListCount;
                this.operationCount[n4] = this.operationCount[n4] + 1;
                bl2 = true;
            }
        }
        return bl2;
    }

    public Double getUpdateTimer() {
        return this.substitutionModelDelegate.updateTime;
    }

    public Double getConvolveTimer() {
        return this.substitutionModelDelegate.convolveTime;
    }

    public void getLogScalingFactors(int n, double[] dArray) {
        if (n < this.tipCount) {
            Arrays.fill(dArray, 0.0);
        } else {
            int n2 = this.scaleBufferIndices[n - this.tipCount];
            this.beagle.getLogScaleFactors(n2, dArray);
        }
    }

    public double[] getSiteLogLikelihoods() {
        this.getLogLikelihood();
        double[] dArray = new double[this.patternCount];
        this.beagle.getSiteLogLikelihoods(dArray);
        return dArray;
    }
}

