/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JointOperator
extends AbstractAdaptableOperator {
    private final ArrayList<SimpleMCMCOperator> operatorList = new ArrayList();
    private final ArrayList<Integer> operatorToOptimizeList = new ArrayList();
    private int currentOptimizedOperator;

    public JointOperator(double d, double d2) {
        super(AdaptationMode.DEFAULT, d2);
        this.setWeight(d);
    }

    public void addOperator(SimpleMCMCOperator simpleMCMCOperator) {
        this.operatorList.add(simpleMCMCOperator);
        if (simpleMCMCOperator instanceof AdaptableMCMCOperator && ((AdaptableMCMCOperator)((Object)simpleMCMCOperator)).getMode() == AdaptationMode.ADAPTATION_ON) {
            this.operatorToOptimizeList.add(this.operatorList.size() - 1);
        }
    }

    @Override
    public final double doOperation() {
        double d = 0.0;
        for (SimpleMCMCOperator simpleMCMCOperator : this.operatorList) {
            d += simpleMCMCOperator.doOperation();
        }
        return d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        if (this.operatorToOptimizeList.size() > 0) {
            this.currentOptimizedOperator = this.operatorToOptimizeList.get(MathUtils.nextInt(this.operatorToOptimizeList.size()));
            return ((AdaptableMCMCOperator)((Object)this.operatorList.get(this.currentOptimizedOperator))).getAdaptableParameter();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        if (this.operatorToOptimizeList.size() > 0) {
            ((AdaptableMCMCOperator)((Object)this.operatorList.get(this.currentOptimizedOperator))).setAdaptableParameter(d);
            return;
        }
        throw new IllegalArgumentException();
    }

    public int getNumberOfSubOperators() {
        return this.operatorList.size();
    }

    public double getRawParameter(int n) {
        if (n < 0 || n >= this.operatorList.size()) {
            throw new IllegalArgumentException();
        }
        return ((AdaptableMCMCOperator)((Object)this.operatorList.get(n))).getRawParameter();
    }

    @Override
    public double getRawParameter() {
        throw new RuntimeException("More than one raw parameter for a joint operator");
    }

    @Override
    public AdaptationMode getMode() {
        if (this.operatorToOptimizeList.size() > 0) {
            return AdaptationMode.ADAPTATION_ON;
        }
        return AdaptationMode.ADAPTATION_OFF;
    }

    public MCMCOperator getSubOperator(int n) {
        return this.operatorList.get(n);
    }

    public AdaptationMode getSubOperatorMode(int n) {
        if (n < 0 || n >= this.operatorList.size()) {
            throw new IllegalArgumentException();
        }
        if (this.operatorList.get(n) instanceof AdaptableMCMCOperator) {
            return ((AdaptableMCMCOperator)((Object)this.operatorList.get(n))).getMode();
        }
        return AdaptationMode.ADAPTATION_OFF;
    }

    public String getSubOperatorName(int n) {
        if (n < 0 || n >= this.operatorList.size()) {
            throw new IllegalArgumentException();
        }
        return "Joint." + this.operatorList.get(n).getOperatorName();
    }

    @Override
    public String getOperatorName() {
        return "JointOperator";
    }

    public Element createOperatorElement(Document document) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getAdaptableParameterName() {
        return "";
    }

    @Override
    public double getMinimumAcceptanceLevel() {
        double d = this.getTargetAcceptanceProbability() - 0.2;
        if (d < 0.0) {
            d = 0.01;
        }
        return d;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        double d = this.getTargetAcceptanceProbability() + 0.2;
        if (d > 1.0) {
            d = 0.9;
        }
        return d;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        double d = this.getTargetAcceptanceProbability() - 0.1;
        if (d < 0.0) {
            d = 0.01;
        }
        return d;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        double d = this.getTargetAcceptanceProbability() + 0.2;
        if (d > 1.0) {
            d = 0.9;
        }
        return d;
    }

    @Override
    public final String getPerformanceSuggestion() {
        return "";
    }
}

