/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.List;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.NeighborJoiningTreeBuilder;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.TreeBuilder;
import jebl.evolution.trees.TreeBuilderFactory;
import jebl.evolution.trees.UPGMATreeBuilder;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusteringTreeBuilder<T extends Tree>
implements TreeBuilder<T> {
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    protected final DistanceMatrix distanceMatrix;
    protected int numClusters;
    protected Node[] clusters;
    protected Node newCluster;
    protected int besti;
    protected int bestj;
    private int abi;
    private int abj;
    protected int[] tipCount;
    protected int[] alias;
    protected double[][] distance;
    protected int numberOfRootSubtrees;

    @Override
    public T build() {
        this.init(this.distanceMatrix);
        double totalPairs = this.numClusters;
        double progress = 0.0;
        while (true) {
            this.findNextPair();
            this.abi = this.alias[this.besti];
            this.abj = this.alias[this.bestj];
            if (this.numClusters < this.numberOfRootSubtrees) break;
            this.newCluster();
            assert (progress <= totalPairs);
            this.fireSetProgress(progress / totalPairs);
            progress += 1.0;
        }
        this.finish();
        return this.getTree();
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSetProgress(double fractionCompleted) {
        for (ProgressListener listener : this.listeners) {
            listener.setProgress(fractionCompleted);
        }
    }

    public static ClusteringTreeBuilder getBuilder(TreeBuilderFactory.Method method, DistanceMatrix distances) {
        ClusteringTreeBuilder builder;
        switch (method) {
            case UPGMA: {
                builder = new UPGMATreeBuilder(distances);
                break;
            }
            default: {
                builder = new NeighborJoiningTreeBuilder(distances);
            }
        }
        return builder;
    }

    protected ClusteringTreeBuilder(DistanceMatrix distanceMatrix, int rootSubtrees) throws IllegalArgumentException {
        this.distanceMatrix = distanceMatrix;
        this.numberOfRootSubtrees = rootSubtrees;
        if (distanceMatrix.getSize() < rootSubtrees) {
            throw new IllegalArgumentException("less than " + rootSubtrees + " taxa in distance matrix");
        }
    }

    protected abstract T getTree();

    protected abstract Node createExternalNode(Taxon var1);

    protected abstract Node createInternalNode(Node[] var1, double[] var2);

    protected abstract double[] joinClusters();

    protected abstract double updatedDistance(int var1);

    protected double getDist(int a, int b) {
        return this.distance[this.alias[a]][this.alias[b]];
    }

    protected void init(DistanceMatrix distanceMatrix) {
        int i;
        this.numClusters = distanceMatrix.getSize();
        this.clusters = new Node[this.numClusters];
        this.distance = new double[this.numClusters][this.numClusters];
        for (int i2 = 0; i2 < this.numClusters; ++i2) {
            for (int j = 0; j < this.numClusters; ++j) {
                this.distance[i2][j] = distanceMatrix.getDistance(i2, j);
                assert (!Double.isNaN(this.distance[i2][j]));
            }
        }
        List<Taxon> taxa = distanceMatrix.getTaxa();
        for (i = 0; i < this.numClusters; ++i) {
            this.clusters[i] = this.createExternalNode(taxa.get(i));
        }
        this.alias = new int[this.numClusters];
        this.tipCount = new int[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            this.alias[i] = i;
            this.tipCount[i] = 1;
        }
    }

    protected void findNextPair() {
        this.besti = 0;
        this.bestj = 1;
        double dmin = this.getDist(0, 1);
        for (int i = 0; i < this.numClusters - 1; ++i) {
            for (int j = i + 1; j < this.numClusters; ++j) {
                double dist = this.getDist(i, j);
                if (!(dist < dmin)) continue;
                dmin = dist;
                this.besti = i;
                this.bestj = j;
            }
        }
    }

    protected void newCluster() {
        double[] d = this.joinClusters();
        Node[] n = new Node[]{this.clusters[this.abi], this.clusters[this.abj]};
        this.clusters[this.abi] = this.newCluster = this.createInternalNode(n, d);
        this.clusters[this.abj] = null;
        for (int k = 0; k < this.numClusters; ++k) {
            if (k == this.besti || k == this.bestj) continue;
            int ak = this.alias[k];
            double d2 = this.updatedDistance(k);
            this.distance[this.abi][ak] = d2;
            this.distance[ak][this.abi] = d2;
            this.distance[this.abj][ak] = -1.0;
            this.distance[ak][this.abj] = -1.0;
        }
        this.distance[this.abi][this.abi] = 0.0;
        this.distance[this.abj][this.abj] = -1.0;
        System.arraycopy(this.alias, this.bestj + 1, this.alias, this.bestj, this.numClusters - 1 - this.bestj);
        int n2 = this.abi;
        this.tipCount[n2] = this.tipCount[n2] + this.tipCount[this.abj];
        this.tipCount[this.abj] = 0;
        --this.numClusters;
    }

    protected void finish() {
        this.distance = null;
    }
}

