/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private float[][] elements;
    private FloatFFT_2D fft2;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;

    public DenseLargeFComplexMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new float[n][2 * n2];
        this.content = this;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void fftColumns() {
        int n;
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFComplexMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFComplexMatrix2D.this.fftColumns.complexForward(fArray);
                            DenseLargeFComplexMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.fftColumns.complexForward(fArray);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void fftRows() {
        int n;
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFComplexMatrix2D.this.fftRows.complexForward(DenseLargeFComplexMatrix2D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftRows.complexForward(this.elements[i]);
            }
        }
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifftColumns(final boolean bl) {
        int n;
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray = (float[])DenseLargeFComplexMatrix2D.this.viewColumn(i).copy().elements();
                            DenseLargeFComplexMatrix2D.this.fftColumns.complexInverse(fArray, bl);
                            DenseLargeFComplexMatrix2D.this.viewColumn(i).assign(fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray = (float[])this.viewColumn(i).copy().elements();
                this.fftColumns.complexInverse(fArray, bl);
                this.viewColumn(i).assign(fArray);
            }
        }
    }

    public void ifftRows(final boolean bl) {
        int n;
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeFComplexMatrix2D.this.fftRows.complexInverse(DenseLargeFComplexMatrix2D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftRows.complexInverse(this.elements[i], bl);
            }
        }
    }

    public float[] getQuick(int n, int n2) {
        return new float[]{this.elements[n][2 * n2], this.elements[n][2 * n2 + 1]};
    }

    public void setQuick(int n, int n2, float[] fArray) {
        this.elements[n][2 * n2] = fArray[0];
        this.elements[n][2 * n2 + 1] = fArray[1];
    }

    public void setQuick(int n, int n2, float f, float f2) {
        this.elements[n][2 * n2] = f;
        this.elements[n][2 * n2 + 1] = f2;
    }

    public float[][] elements() {
        return this.elements;
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new DenseLargeFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return new DenseFComplexMatrix1D(n);
    }
}

