## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ABCDscores)

## -----------------------------------------------------------------------------
data <- tibble::tibble(
  fc_p_psb_001 = c("1", "2", "3", "4", "5"),
  fc_p_psb_002 = c("1", NA, "3", "4", NA),
  fc_p_psb_003 = c("1", "2", "2", "4", NA)
)
data

## -----------------------------------------------------------------------------
compute_fc_p_psb_mean(data)

## -----------------------------------------------------------------------------
compute_fc_p_psb_nm(data)

## -----------------------------------------------------------------------------
data |>
  compute_fc_p_psb_mean() |>
  compute_fc_p_psb_nm()

## -----------------------------------------------------------------------------
compute_fc_p_psb_all(data)

## -----------------------------------------------------------------------------
compute_fc_p_psb_mean(data, name = "my_custom_name")

## -----------------------------------------------------------------------------
compute_fc_p_psb_mean(data, combine = FALSE)

## -----------------------------------------------------------------------------
compute_fc_p_psb_mean(data, max_na = 1)

## -----------------------------------------------------------------------------
compute_fc_p_psb_mean(data, max_na = 2)

## -----------------------------------------------------------------------------
data <- tibble::tibble(
  mh_p_abcl__frnd_001 = c(1, 2, 3, 4, 5),
  mh_p_abcl__frnd_002 = c(1, 777, 3, 4, 777),
  mh_p_abcl__frnd_003 = c(1, 2, NA, 4, 777),
  mh_p_abcl__frnd_004 = c(1, 2, 3, 4, 999),
)
data

## -----------------------------------------------------------------------------
compute_mh_p_abcl__afs__frnd_sum(data, exclude = c("777", "999"))

## -----------------------------------------------------------------------------
compute_mh_p_abcl__afs__frnd_sum(data, exclude = c("777", "999", "4"))

