/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class ConstExpConst
extends DemographicFunction.Abstract {
    private double N0;
    private double N1;
    private double time1;
    private double epochTime;
    private double growthRate;
    private final boolean useNumericalIntegrator;
    private final Parameterization parameterization;

    public ConstExpConst(Units.Type type) {
        this(Parameterization.ANCESTRAL_POPULATION_SIZE, false, type);
    }

    public ConstExpConst(Parameterization parameterization, boolean bl, Units.Type type) {
        super(type);
        this.parameterization = parameterization;
        this.useNumericalIntegrator = bl;
    }

    public double getN0() {
        return this.N0;
    }

    public void setN0(double d) {
        this.N0 = d;
    }

    public double getN1() {
        if (this.parameterization == Parameterization.ANCESTRAL_POPULATION_SIZE) {
            return this.N1;
        }
        return this.N0 * Math.exp(-this.epochTime * this.growthRate);
    }

    public void setN1(double d) {
        assert (this.parameterization == Parameterization.ANCESTRAL_POPULATION_SIZE);
        this.N1 = d;
    }

    public double getTime1() {
        return this.time1;
    }

    public void setTime1(double d) {
        this.time1 = d;
    }

    public double getEpochTime() {
        return this.epochTime;
    }

    public void setEpochTime(double d) {
        this.epochTime = d;
    }

    public double getTime2() {
        return this.time1 + this.epochTime;
    }

    public final void setGrowthRate(double d) {
        assert (this.parameterization == Parameterization.GROWTH_RATE);
        this.growthRate = d;
    }

    public final double getGrowthRate() {
        if (this.parameterization == Parameterization.GROWTH_RATE) {
            return this.growthRate;
        }
        return (Math.log(this.N0) - Math.log(this.N1)) / this.epochTime;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getGrowthRate();
        if (d < this.getTime1()) {
            return this.getN0();
        }
        if (d >= this.getTime2()) {
            return this.getN1();
        }
        return this.getN0() * Math.exp(-d2 * (d - this.getTime1()));
    }

    @Override
    public double getIntegral(double d, double d2) {
        if (this.useNumericalIntegrator) {
            return this.getNumericalIntegral(d, d2);
        }
        return this.getIntensity(d2) - this.getIntensity(d);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getTime2();
        double d3 = 1.0 / this.getN0();
        double d4 = this.getGrowthRate();
        if (d < this.time1) {
            return d * d3;
        }
        if (d > this.time1 && d < d2) {
            return this.time1 * d3 + (Math.exp(d * d4) - Math.exp(this.time1 * d4)) * d3 / d4;
        }
        double d5 = 1.0 / this.getN1();
        return this.time1 * d3 + (Math.exp(d2 * d4) - Math.exp(this.time1 * d4)) * d3 / d4 + d5 * (d - d2);
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return this.parameterization == Parameterization.ANCESTRAL_POPULATION_SIZE ? "N1" : "r";
            }
            case 2: {
                return "epochTime";
            }
            case 3: {
                return "time1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.parameterization == Parameterization.ANCESTRAL_POPULATION_SIZE ? this.getN1() : this.getGrowthRate();
            }
            case 2: {
                return this.getEpochTime();
            }
            case 3: {
                return this.getTime1();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                if (this.parameterization == Parameterization.ANCESTRAL_POPULATION_SIZE) {
                    this.setN1(d);
                    break;
                }
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setEpochTime(d);
                break;
            }
            case 3: {
                this.setTime1(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        if (n == 1 && this.parameterization == Parameterization.GROWTH_RATE) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    public static enum Parameterization {
        GROWTH_RATE,
        ANCESTRAL_POPULATION_SIZE;

    }
}

