/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SplitSystem;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;

public class SplitUtils {
    public static SplitSystem getSplits(TaxonList taxonList, Tree tree) {
        int n = tree.getInternalNodeCount() - 1;
        SplitSystem splitSystem = new SplitSystem(taxonList, n);
        boolean[][] blArray = splitSystem.getSplitVector();
        int n2 = 0;
        for (int i = 0; i < tree.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            if (nodeRef == tree.getRoot()) continue;
            SplitUtils.getSplit(taxonList, tree, nodeRef, blArray[n2]);
            ++n2;
        }
        return splitSystem;
    }

    public static SplitSystem getSplits(Tree tree) {
        return SplitUtils.getSplits(tree, tree);
    }

    public static void getSplit(TaxonList taxonList, Tree tree, NodeRef nodeRef, boolean[] blArray) {
        int n;
        if (tree.isExternal(nodeRef) || tree.isRoot(nodeRef)) {
            throw new IllegalArgumentException("Only internal nodes (and no root) nodes allowed");
        }
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            SplitUtils.markNode(taxonList, tree, nodeRef, blArray);
        }
        if (!blArray[0]) {
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = !blArray[n];
            }
        }
    }

    public static boolean isSame(boolean[] blArray, boolean[] blArray2) {
        boolean bl;
        boolean bl2 = bl = blArray[0] != blArray2[0];
        if (blArray.length != blArray2.length) {
            throw new IllegalArgumentException("Splits must be of the same length!");
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (!(bl ? blArray[i] == blArray2[i] : blArray[i] != blArray2[i])) continue;
            return false;
        }
        return true;
    }

    static void markNode(TaxonList taxonList, Tree tree, NodeRef nodeRef, boolean[] blArray) {
        if (tree.isExternal(nodeRef)) {
            String string = tree.getTaxonId(nodeRef.getNumber());
            int n = taxonList.getTaxonIndex(string);
            if (n < 0) {
                throw new IllegalArgumentException("INCOMPATIBLE IDENTIFIER (" + string + ")");
            }
            blArray[n] = true;
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                SplitUtils.markNode(taxonList, tree, tree.getChild(nodeRef, i), blArray);
            }
        }
    }
}

