/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.distance.DistanceMatrix;
import dr.evolution.tree.ClusteringTree;

public class UPGMATree
extends ClusteringTree {
    public UPGMATree(DistanceMatrix distanceMatrix) {
        super(distanceMatrix, 2);
    }

    @Override
    protected void findNextPair() {
        this.besti = 0;
        this.bestj = 1;
        double d = this.getDist(0, 1);
        for (int i = 0; i < this.numClusters - 1; ++i) {
            for (int j = i + 1; j < this.numClusters; ++j) {
                if (!(this.getDist(i, j) < d)) continue;
                d = this.getDist(i, j);
                this.besti = i;
                this.bestj = j;
            }
        }
        this.abi = this.alias[this.besti];
        this.abj = this.alias[this.bestj];
    }

    @Override
    protected double newNodeHeight() {
        return this.getDist(this.besti, this.bestj) / 2.0;
    }

    @Override
    protected double updatedDistance(int n, int n2, int n3) {
        int n4 = this.alias[n];
        int n5 = this.alias[n2];
        double d = this.tipCount[n4] + this.tipCount[n5];
        return (double)this.tipCount[n4] / d * this.getDist(n3, n) + (double)this.tipCount[n5] / d * this.getDist(n3, n2);
    }
}

