/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.operators;

import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class AlloppHybPopSizesScale
extends SimpleMCMCOperator {
    private final AlloppSpeciesNetworkModel apspnet;
    private final AlloppSpeciesBindings apsp;
    private final double scalingFactor;

    public AlloppHybPopSizesScale(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, AlloppSpeciesBindings alloppSpeciesBindings, double d, double d2) {
        this.apspnet = alloppSpeciesNetworkModel;
        this.apsp = alloppSpeciesBindings;
        this.scalingFactor = d;
        this.setWeight(d2);
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return "hybPopSizesScaleOperator(" + this.apspnet.getId() + "," + this.apsp.getId() + ")";
    }

    @Override
    public double doOperation() {
        this.apspnet.beginNetworkEdit();
        double d = (1.0 - this.scalingFactor) * (1.0 - this.scalingFactor) / this.scalingFactor;
        double d2 = this.scalingFactor / (1.0 - this.scalingFactor);
        double d3 = MathUtils.nextDouble();
        double d4 = d * (d3 + d2) * (d3 + d2);
        int n = MathUtils.nextInt(this.apspnet.getNumberOfTetraTrees());
        this.apspnet.setOneHybPopValue(n, d4 * this.apspnet.getOneHybPopValue(n));
        this.apspnet.endNetworkEdit();
        return 0.0;
    }
}

