/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.operators.AlloppChangeNumHybridizations;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AlloppChangeNumHybridizationsParser
extends AbstractXMLObjectParser {
    public static final String CHANGE_NUM_HYBRIDIZATIONS = "changeNumHybridizations";

    @Override
    public String getParserName() {
        return CHANGE_NUM_HYBRIDIZATIONS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        AlloppSpeciesBindings alloppSpeciesBindings = (AlloppSpeciesBindings)xMLObject.getChild(AlloppSpeciesBindings.class);
        AlloppSpeciesNetworkModel alloppSpeciesNetworkModel = (AlloppSpeciesNetworkModel)xMLObject.getChild(AlloppSpeciesNetworkModel.class);
        if (alloppSpeciesNetworkModel.getOneHybridization()) {
            throw new XMLParseException("oneHybridization is set to true but there is a changeNumHybridizations operator");
        }
        double d = xMLObject.getDoubleAttribute("weight");
        return new AlloppChangeNumHybridizations(alloppSpeciesNetworkModel, alloppSpeciesBindings, d);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(AlloppSpeciesBindings.class), new ElementRule(AlloppSpeciesNetworkModel.class)};
    }

    @Override
    public String getParserDescription() {
        return "Operator which changes the number of tetraploid subtrees (hybridizations) by merging and splitting them.";
    }

    @Override
    public Class getReturnType() {
        return AlloppChangeNumHybridizations.class;
    }
}

