/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evomodel.alloppnet.operators.MulTreeNodeSlide;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.alloppnet.speciation.MulSpeciesTreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MulTreeNodeSlideParser
extends AbstractXMLObjectParser {
    public static final String MULTREE_NODE_REHEIGHT = "mulTreeNodeReHeight";

    @Override
    public String getParserName() {
        return MULTREE_NODE_REHEIGHT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        MulSpeciesBindings mulSpeciesBindings = (MulSpeciesBindings)xMLObject.getChild(MulSpeciesBindings.class);
        MulSpeciesTreeModel mulSpeciesTreeModel = (MulSpeciesTreeModel)xMLObject.getChild(MulSpeciesTreeModel.class);
        double d = xMLObject.getDoubleAttribute("weight");
        return new MulTreeNodeSlide(mulSpeciesTreeModel, mulSpeciesBindings, d);
    }

    @Override
    public String getParserDescription() {
        return "Specialized Species tree operator, transform tree without breaking embedding of gene trees.";
    }

    @Override
    public Class getReturnType() {
        return MulTreeNodeSlide.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(MulSpeciesBindings.class), new ElementRule(MulSpeciesTreeModel.class)};
    }
}

