/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DriftedTraitsLogger
implements TreeTraitProvider {
    public static final String DRIFTED_TRAITS_LOGGER = "driftedTraits";
    private final AbstractMultivariateTraitLikelihood multivariateTraits;
    private final Parameter locationDriftParameter;
    private TreeTrait[] treeTraits = null;
    private double maxHeight = -1.0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AbstractMultivariateTraitLikelihood.class, "The tree trait provider which is to be drifted."), new ElementRule(Parameter.class, "The parameter specifying location drift rate.")};

        @Override
        public String getParserName() {
            return DriftedTraitsLogger.DRIFTED_TRAITS_LOGGER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new DriftedTraitsLogger(abstractMultivariateTraitLikelihood, parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public String getExample() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return TreeTraitProvider.class;
        }
    };

    public DriftedTraitsLogger(AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, Parameter parameter) {
        this.multivariateTraits = abstractMultivariateTraitLikelihood;
        this.locationDriftParameter = parameter;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        if (this.treeTraits == null) {
            this.treeTraits = new TreeTrait[]{new TreeTrait.DA(){

                @Override
                public String getTraitName() {
                    return DriftedTraitsLogger.this.multivariateTraits.getTraitName();
                }

                @Override
                public TreeTrait.Intent getIntent() {
                    return TreeTrait.Intent.NODE;
                }

                @Override
                public Class getTraitClass() {
                    return Double.class;
                }

                @Override
                public double[] getTrait(Tree tree, NodeRef nodeRef) {
                    double[] dArray = DriftedTraitsLogger.this.multivariateTraits.getTraitForNode(tree, nodeRef, DriftedTraitsLogger.this.multivariateTraits.getTraitName());
                    DriftedTraitsLogger.this.computeMaxHeight(tree);
                    double d = tree.getNodeHeight(nodeRef);
                    double d2 = DriftedTraitsLogger.this.locationDriftParameter.getParameterValue(0) * (DriftedTraitsLogger.this.maxHeight - d);
                    dArray[0] = dArray[0] + d2;
                    return dArray;
                }
            }};
        }
        return this.treeTraits;
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        TreeTrait[] treeTraitArray;
        for (TreeTrait treeTrait : treeTraitArray = this.getTreeTraits()) {
            if (!treeTrait.getTraitName().equals(string)) continue;
            return treeTrait;
        }
        return null;
    }

    private void computeMaxHeight(Tree tree) {
        if (this.maxHeight < 0.0) {
            int n = tree.getTaxonCount();
            for (int i = 0; i < n; ++i) {
                Taxon taxon = tree.getTaxon(i);
                double d = taxon.getHeight();
                if (!(d > this.maxHeight)) continue;
                this.maxHeight = d;
            }
        }
    }
}

