/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGPartitionLikelihood;
import dr.evomodel.arg.PoissonPartitionLikelihood;
import dr.evomodel.arg.UniformPartitionLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class HierarchicalPartitionLikelihood
extends ARGPartitionLikelihood {
    public static final String HIERARCHICAL_PARTITION_LIKELIHOOD = "hierarchicalPartitionLikelihood";
    private Parameter probabilities;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return PoissonPartitionLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ARGModel.class, false)};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = "";
            if (xMLObject.hasId()) {
                string = xMLObject.getId();
            }
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            if (parameter.getDimension() != aRGModel.getNumberOfPartitions() - 1) {
                throw new XMLParseException("The dimension of the parameter must equal the number of partitions minus 1 ");
            }
            if (aRGModel.isRecombinationPartitionType()) {
                throw new XMLParseException("argTreeModel must be of type reassortment");
            }
            return new HierarchicalPartitionLikelihood(string, aRGModel, parameter);
        }

        @Override
        public String getParserName() {
            return HierarchicalPartitionLikelihood.HIERARCHICAL_PARTITION_LIKELIHOOD;
        }
    };

    public HierarchicalPartitionLikelihood(String string, ARGModel aRGModel, Parameter parameter) {
        super(string, aRGModel);
        this.probabilities = parameter;
        this.addVariable(parameter);
        this.addModel(aRGModel);
    }

    @Override
    public double[] generatePartition() {
        int n;
        double[] dArray = new double[this.getNumberOfPartitionsMinusOne() + 1];
        dArray[0] = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.0;
        }
        while (UniformPartitionLikelihood.arraySum(dArray) == 0.0) {
            for (n = 1; n < dArray.length; ++n) {
                dArray[n] = MathUtils.nextDouble() < this.probabilities.getParameterValue(n - 1) ? 1.0 : 0.0;
            }
        }
        return dArray;
    }

    @Override
    public double getLogLikelihood(double[] dArray) {
        double d = 0.0;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] == 1.0) {
                d += Math.log(this.probabilities.getParameterValue(i - 1));
                continue;
            }
            d += Math.log(1.0 - this.probabilities.getParameterValue(i - 1));
        }
        return d;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void storeState() {
    }
}

