/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.operators.SubtreeSlideOperator;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class ARGSubtreeSlideOperator
extends AbstractAdaptableOperator {
    public static final String SUBTREE_SLIDE = "argSubtreeSlide";
    public static final String SWAP_RATES = "swapRates";
    public static final String SWAP_TRAITS = "swapTraits";
    public static final String DIRICHLET_BRANCHES = "branchesAreScaledDirichlet";
    private ARGModel tree = null;
    private double size = 1.0;
    private boolean gaussian = false;
    private boolean swapRates;
    private boolean swapTraits;
    private boolean scaledDirichletBranches;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), AttributeRule.newDoubleRule("size"), AttributeRule.newBooleanRule("gaussian"), AttributeRule.newBooleanRule("swapRates", true), AttributeRule.newBooleanRule("swapTraits", true), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ARGSubtreeSlideOperator.SUBTREE_SLIDE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            if (xMLObject.hasAttribute(ARGSubtreeSlideOperator.SWAP_RATES)) {
                bl = xMLObject.getBooleanAttribute(ARGSubtreeSlideOperator.SWAP_RATES);
            }
            if (xMLObject.hasAttribute(ARGSubtreeSlideOperator.SWAP_TRAITS)) {
                bl2 = xMLObject.getBooleanAttribute(ARGSubtreeSlideOperator.SWAP_TRAITS);
            }
            if (xMLObject.hasAttribute(ARGSubtreeSlideOperator.DIRICHLET_BRANCHES)) {
                bl3 = xMLObject.getBooleanAttribute(ARGSubtreeSlideOperator.DIRICHLET_BRANCHES);
            }
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            int n = xMLObject.getIntegerAttribute("weight");
            double d = xMLObject.getDoubleAttribute("size");
            boolean bl4 = xMLObject.getBooleanAttribute("gaussian");
            return new ARGSubtreeSlideOperator(aRGModel, n, d, bl4, bl, bl2, bl3, adaptationMode);
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a subtree.";
        }

        @Override
        public Class getReturnType() {
            return SubtreeSlideOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ARGSubtreeSlideOperator(ARGModel aRGModel, int n, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.tree = aRGModel;
        this.setWeight(n);
        this.size = d;
        this.gaussian = bl;
        this.swapRates = bl2;
        this.swapTraits = bl3;
        this.scaledDirichletBranches = bl4;
    }

    public void sanityCheck() {
        int n = this.tree.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.tree.getNode(i);
            if (node.bifurcation) {
                boolean bl;
                boolean bl2 = bl = node.leftChild == node.rightChild;
                if (!bl || node.leftChild == null || !node.leftChild.bifurcation && node.leftChild.leftParent == node) continue;
                System.err.println("Node " + (i + 1) + " is insane.");
                System.err.println(this.tree.toGraphString());
                System.exit(-1);
                continue;
            }
            if (node.leftChild == node.rightChild) continue;
            System.err.println("Node " + (i + 1) + " is insane.");
            System.err.println(this.tree.toGraphString());
            System.exit(-1);
        }
    }

    @Override
    public double doOperation() {
        NodeRef nodeRef;
        double d = 0.0;
        double d2 = this.tree.getNodeHeight(this.tree.getRoot());
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        int n = this.getSlideableSubtrees(this.tree, arrayList);
        NodeRef nodeRef2 = arrayList.get(MathUtils.nextInt(n));
        NodeRef nodeRef3 = this.tree.getParent(nodeRef2);
        NodeRef nodeRef4 = this.getOtherChild(this.tree, nodeRef3, nodeRef2);
        if (this.tree.isBifurcation(nodeRef3)) {
            nodeRef = this.tree.getParent(nodeRef3);
        } else {
            nodeRef = this.tree.getParent(nodeRef3, MathUtils.nextInt(2));
            d -= Math.log(2.0);
        }
        double d3 = this.getDelta();
        double d4 = this.tree.getNodeHeight(nodeRef3);
        double d5 = d4 + d3;
        if (d3 > 0.0) {
            if (nodeRef != null && this.tree.getNodeHeight(nodeRef) < d5) {
                NodeRef nodeRef5 = nodeRef;
                NodeRef nodeRef6 = nodeRef3;
                while (this.tree.getNodeHeight(nodeRef5) < d5) {
                    nodeRef6 = nodeRef5;
                    if (this.tree.isBifurcation(nodeRef5)) {
                        nodeRef5 = this.tree.getParent(nodeRef5);
                    } else {
                        nodeRef5 = this.tree.getParent(nodeRef5, MathUtils.nextInt(2));
                        d -= Math.log(2.0);
                    }
                    if (nodeRef5 != null) continue;
                }
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef6)) {
                    this.tree.endTreeEdit();
                    try {
                        this.tree.checkTreeIsValid();
                    }
                    catch (MutableTree.InvalidTreeException invalidTreeException) {
                        invalidTreeException.printStackTrace();
                    }
                    throw new RuntimeException("Temporarily disable re-rooting");
                }
                int n2 = this.tree.isBifurcationDoublyLinked(nodeRef5);
                this.tree.doubleRemoveChild(nodeRef3, nodeRef4);
                this.tree.doubleRemoveChild(nodeRef, nodeRef3);
                this.tree.doubleRemoveChild(nodeRef5, nodeRef6);
                this.tree.doubleAddChild(nodeRef, nodeRef4);
                if (n2 == 0) {
                    this.tree.doubleAddChild(nodeRef3, nodeRef6);
                    this.tree.doubleAddChild(nodeRef5, nodeRef3);
                } else {
                    this.tree.singleAddChild(nodeRef5, nodeRef3);
                    this.tree.singleAddChildWithOneParent(nodeRef3, nodeRef6);
                    this.tree.singleAddChild(nodeRef5, nodeRef6);
                }
                this.tree.setNodeHeight(nodeRef3, d5);
                this.tree.endTreeEdit();
                try {
                    this.tree.checkTreeIsValid();
                }
                catch (MutableTree.InvalidTreeException invalidTreeException) {
                    throw new RuntimeException(invalidTreeException.toString());
                }
                n2 = this.intersectingEdges(this.tree, nodeRef6, nodeRef3, d4, null);
                d -= Math.log(n2);
            } else {
                this.tree.setNodeHeight(nodeRef3, d5);
                d = 0.0;
            }
        } else {
            if (this.tree.getNodeHeight(nodeRef2) > d5) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.tree.getNodeHeight(nodeRef4) > d5) {
                boolean bl;
                ArrayList<NodeRef[]> arrayList2 = new ArrayList<NodeRef[]>();
                int n3 = this.intersectingEdges(this.tree, nodeRef4, nodeRef3, d5, arrayList2);
                if (arrayList2.size() == 0) {
                    throw new RuntimeException("no valid destinations");
                }
                int n4 = MathUtils.nextInt(arrayList2.size());
                NodeRef[] nodeRefArray = arrayList2.get(n4);
                NodeRef nodeRef7 = nodeRefArray[1];
                NodeRef nodeRef8 = nodeRefArray[0];
                Object var23_24 = null;
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef3)) {
                    if (!this.tree.isBifurcation(nodeRef4)) {
                        throw new RuntimeException("root cannot be a reassortment");
                    }
                    bl = this.tree.isBifurcationDoublyLinked(nodeRef8);
                    this.tree.doubleRemoveChild(nodeRef3, nodeRef4);
                    this.tree.doubleRemoveChild(nodeRef8, nodeRef7);
                    if (this.tree.isBifurcation(nodeRef7)) {
                        this.tree.doubleAddChild(nodeRef3, nodeRef7);
                    } else {
                        this.tree.singleAddChildWithOneParent(nodeRef3, nodeRef7);
                    }
                    if (!bl) {
                        this.tree.doubleAddChild(nodeRef8, nodeRef3);
                    } else {
                        this.tree.singleAddChild(nodeRef8, nodeRef3);
                        this.tree.singleAddChildWithOneParent(nodeRef8, nodeRef7);
                    }
                    this.tree.setRoot(nodeRef4);
                } else {
                    bl = this.tree.isBifurcationDoublyLinked(nodeRef8);
                    this.tree.doubleRemoveChild(nodeRef3, nodeRef4);
                    this.tree.doubleRemoveChild(nodeRef, nodeRef3);
                    this.tree.doubleRemoveChild(nodeRef8, nodeRef7);
                    if (this.tree.isBifurcation(nodeRef7)) {
                        this.tree.doubleAddChild(nodeRef3, nodeRef7);
                    } else {
                        this.tree.singleAddChildWithOneParent(nodeRef3, nodeRef7);
                    }
                    this.tree.doubleAddChild(nodeRef, nodeRef4);
                    if (!bl) {
                        this.tree.doubleAddChild(nodeRef8, nodeRef3);
                    } else {
                        this.tree.singleAddChild(nodeRef8, nodeRef3);
                        this.tree.singleAddChildWithOneParent(nodeRef8, nodeRef7);
                    }
                }
                this.tree.setNodeHeight(nodeRef3, d5);
                this.tree.endTreeEdit();
                try {
                    this.tree.checkTreeIsValid();
                }
                catch (MutableTree.InvalidTreeException invalidTreeException) {
                    throw new RuntimeException(invalidTreeException.toString());
                }
                d += Math.log(n3);
            } else {
                try {
                    this.tree.setNodeHeight(nodeRef3, d5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                d = 0.0;
            }
        }
        if (this.tree.isBifurcationDoublyLinked(this.tree.getRoot())) {
            throw new RuntimeException("invalid slide");
        }
        if (!this.tree.validRoot()) {
            throw new RuntimeException("Roots are invalid");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            throw new RuntimeException("invalid slide");
        }
        if (this.scaledDirichletBranches && d2 != this.tree.getNodeHeight(this.tree.getRoot())) {
            throw new RuntimeException("Temporarily disabled.");
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private int getSlideableSubtrees(ARGModel aRGModel, ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = aRGModel.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            NodeRef nodeRef = aRGModel.getNode(i);
            if (aRGModel.isRoot(nodeRef) || !aRGModel.isBifurcation(nodeRef) || !aRGModel.isBifurcation(aRGModel.getParent(nodeRef))) continue;
            if (arrayList != null) {
                arrayList.add(nodeRef);
            }
            ++n;
        }
        return n;
    }

    private int intersectingEdges(ARGModel aRGModel, NodeRef nodeRef, NodeRef nodeRef2, double d, ArrayList<NodeRef[]> arrayList) {
        if (aRGModel.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (aRGModel.getNodeHeight(nodeRef) < d) {
            if (arrayList != null) {
                NodeRef[] nodeRefArray = new NodeRef[]{nodeRef2, nodeRef};
                arrayList.add(nodeRefArray);
            }
            return 1;
        }
        int n = 0;
        n += this.intersectingEdges(aRGModel, aRGModel.getChild(nodeRef, 0), nodeRef, d, arrayList);
        if (aRGModel.isBifurcation(nodeRef)) {
            n += this.intersectingEdges(aRGModel, aRGModel.getChild(nodeRef, 1), nodeRef, d, arrayList);
        }
        return n;
    }

    private NodeRef getOtherChild(Tree tree, NodeRef nodeRef, NodeRef nodeRef2) {
        if (tree.getChild(nodeRef, 0) == nodeRef2) {
            return tree.getChild(nodeRef, 1);
        }
        return tree.getChild(nodeRef, 0);
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return SUBTREE_SLIDE;
    }
}

