/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExpConstExpDemographic;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ExpConstExpDemographicModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter N1Parameter = null;
    Parameter growthRateParameter = null;
    Parameter timeParameter = null;
    Parameter relTimeParameter = null;
    ExpConstExpDemographic expConstExp = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ExpConstExpDemographicModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Units.Type type) {
        this("expConstExp", parameter, parameter2, parameter3, parameter4, parameter5, type);
    }

    public ExpConstExpDemographicModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Units.Type type) {
        super(string);
        this.expConstExp = new ExpConstExpDemographic(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.N1Parameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.timeParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.relTimeParameter = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(1.0, Double.MIN_VALUE, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.expConstExp.setN0(this.N0Parameter.getParameterValue(0));
        double d = this.relTimeParameter.getParameterValue(0);
        double d2 = this.timeParameter.getParameterValue(0) - this.getTimeOffset();
        double d3 = d2 * d;
        double d4 = -Math.log(this.N1Parameter.getParameterValue(0)) / d3;
        this.expConstExp.setGrowthRate(d4);
        this.expConstExp.setGrowthRate2(this.growthRateParameter.getParameterValue(0));
        this.expConstExp.setTime1(d3);
        this.expConstExp.setPlateauTime(d2 - d3);
        return this.expConstExp;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Exponential-Constant-Exponential Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

