/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.MultiEpochExponential;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;

public class MultiEpochExponentialModel
extends DemographicModel {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter transitionTimeParameter = null;
    MultiEpochExponential multiEpochExponential = null;

    public MultiEpochExponentialModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        super(string);
        int n = parameter2.getDimension();
        if (n != parameter3.getDimension() + 1) {
            throw new IllegalArgumentException("Invalid parameter dimensions");
        }
        this.multiEpochExponential = new MultiEpochExponential(type, n);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter2.getDimension()));
        this.transitionTimeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter3.getDimension()));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.multiEpochExponential.setN0(this.N0Parameter.getParameterValue(0));
        for (int i = 0; i < this.growthRateParameter.getDimension(); ++i) {
            this.multiEpochExponential.setGrowthRate(i, this.growthRateParameter.getParameterValue(i));
        }
        double d = 0.0;
        for (int i = 0; i < this.transitionTimeParameter.getDimension(); ++i) {
            this.multiEpochExponential.setTransitionTime(i, d += this.transitionTimeParameter.getParameterValue(i));
        }
        return this.multiEpochExponential;
    }
}

