/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.GaussianProcessFromTree;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.math.distributions.NormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LatentFactorModelSimulator {
    public static final String SIMULATE_LATENT_FACTOR_MODEL = "simulateLatentFactorModel";
    public static final String PRECISION = "precision";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(FullyConjugateMultivariateTraitLikelihood.class), new ElementRule(MatrixParameterInterface.class), new ElementRule("precision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return LatentFactorModelSimulator.SIMULATE_LATENT_FACTOR_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood = (FullyConjugateMultivariateTraitLikelihood)xMLObject.getChild(FullyConjugateMultivariateTraitLikelihood.class);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            GaussianProcessFromTree gaussianProcessFromTree = new GaussianProcessFromTree(fullyConjugateMultivariateTraitLikelihood);
            int n = fullyConjugateMultivariateTraitLikelihood.getTreeModel().getExternalNodeCount();
            int n2 = matrixParameterInterface.getRowDimension();
            FastMatrixParameter fastMatrixParameter = new FastMatrixParameter(string, n2, n, 0.0);
            if (fullyConjugateMultivariateTraitLikelihood.getNumData() * fullyConjugateMultivariateTraitLikelihood.getDimTrait() != matrixParameterInterface.getColumnDimension()) {
                throw new RuntimeException("Number of factors in tree and loadings matrix must be identical:\n Factor Matrix: " + fullyConjugateMultivariateTraitLikelihood.getNumData() * fullyConjugateMultivariateTraitLikelihood.getDimTrait() + "\n Loadings Matrix: " + matrixParameterInterface.getColumnDimension());
            }
            Parameter parameter = (Parameter)xMLObject.getChild(LatentFactorModelSimulator.PRECISION).getChild(Parameter.class);
            int n3 = matrixParameterInterface.getColumnDimension();
            double[] dArray = gaussianProcessFromTree.nextRandomFast();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n3; ++k) {
                        d += dArray[j * n3 + k] * matrixParameterInterface.getParameterValue(i, k);
                    }
                    double d2 = (Double)new NormalDistribution(d, 1.0 / Math.sqrt(parameter.getParameterValue(i))).nextRandom();
                    fastMatrixParameter.setParameterValue(i, j, d2);
                }
            }
            return fastMatrixParameter;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Simulates a data matrix for a Latent Factor Model";
        }

        @Override
        public Class getReturnType() {
            return MatrixParameter.class;
        }
    };
}

