/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evomodel.epidemiology.DynamicalVariable;
import java.util.ArrayList;
import java.util.List;

public class DynamicalForce {
    private String name = "force";
    private double coefficient = 0.0;
    private List<DynamicalVariable> multipliers = new ArrayList<DynamicalVariable>();
    private List<DynamicalVariable> divisors = new ArrayList<DynamicalVariable>();
    private DynamicalVariable increasingVariable;
    private DynamicalVariable decreasingVariable;
    private double storedCoefficient = 0.0;

    public DynamicalForce(String string, double d, DynamicalVariable dynamicalVariable, DynamicalVariable dynamicalVariable2) {
        this.name = string;
        this.coefficient = d;
        this.increasingVariable = dynamicalVariable;
        this.decreasingVariable = dynamicalVariable2;
    }

    public String getName() {
        return this.name;
    }

    public void addMultiplier(DynamicalVariable dynamicalVariable) {
        this.multipliers.add(dynamicalVariable);
    }

    public void addDivisor(DynamicalVariable dynamicalVariable) {
        this.divisors.add(dynamicalVariable);
    }

    public void reset(double d) {
        this.coefficient = d;
    }

    public void store() {
        this.storedCoefficient = this.coefficient;
    }

    public void restore() {
        this.coefficient = this.storedCoefficient;
    }

    public double getForce(double d) {
        double d2 = this.coefficient;
        for (DynamicalVariable dynamicalVariable : this.multipliers) {
            d2 *= dynamicalVariable.getValue(d);
        }
        for (DynamicalVariable dynamicalVariable : this.divisors) {
            d2 /= dynamicalVariable.getValue(d);
        }
        if (this.increasingVariable.getValue(d) < 0.0 || this.decreasingVariable.getValue(d) < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public void modCurrentValue(double d, double d2) {
        double d3 = this.getForce(d) * d2;
        this.increasingVariable.modCurrentValue(d3);
        this.decreasingVariable.modCurrentValue(-d3);
    }
}

