/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModelAtStationarity;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import java.util.List;

public class BirthDeathSubstitutionModel
extends ComplexSubstitutionModelAtStationarity {
    private final List<Parameter> parameters;
    private final BirthDeathParameterization parameterization;
    private final boolean useStationaryDistribution;
    private final int dim;

    public BirthDeathSubstitutionModel(String string, List<Parameter> list, DataType dataType, boolean bl) {
        super(string, dataType, (Parameter)null);
        this.parameters = list;
        int n = 0;
        for (Parameter parameter : list) {
            this.addVariable(parameter);
            n += parameter.getDimension();
        }
        this.dim = n;
        this.useStationaryDistribution = bl;
        this.parameterization = BirthDeathParameterization.LINEAR;
        this.freqModel = this.setupEquilibriumModel();
        BirthDeathSubstitutionModel.checkDataType(dataType);
        if (this.dim != this.parameterization.getRequiredDimension()) {
            throw new IllegalArgumentException("Invalid parameterization for birth-death substitution process");
        }
    }

    @Override
    protected void frequenciesChanged() {
        throw new RuntimeException("Frequencies are fixed to birth-death equilibrium distribution");
    }

    @Override
    protected double[] getPi() {
        return this.freqModel.getFrequencies();
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
    }

    @Override
    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        double[] dArray4 = this.getRates();
        for (int i = 1; i < this.stateCount; ++i) {
            dArray3[i - 1][i] = this.parameterization.birthRate(i, dArray4);
            dArray3[i][i - 1] = this.parameterization.deathRate(i + 1, dArray4);
        }
    }

    @Override
    protected double getNormalizationValue(double[][] dArray, double[] dArray2) {
        return 1.0;
    }

    @Override
    public double getLogLikelihood() {
        return 0.0;
    }

    private double[] getRates() {
        double[] dArray = new double[this.dim];
        int n = 0;
        for (Parameter parameter : this.parameters) {
            for (int i = 0; i < parameter.getDimension(); ++i) {
                dArray[n + i] = parameter.getParameterValue(i);
            }
            n += parameter.getDimension();
        }
        return dArray;
    }

    private FrequencyModel setupEquilibriumModel() {
        Parameter.Proxy proxy = new Parameter.Proxy("equilibrium", this.stateCount){

            @Override
            public double getParameterValue(int n) {
                if (BirthDeathSubstitutionModel.this.useStationaryDistribution) {
                    return BirthDeathSubstitutionModel.this.getStationaryDistribution()[n];
                }
                return 1.0 / (double)BirthDeathSubstitutionModel.this.stateCount;
            }

            @Override
            public void setParameterValue(int n, double d) {
                throw new IllegalArgumentException("Cannot set equilibrium");
            }

            @Override
            public void setParameterValueQuietly(int n, double d) {
                throw new IllegalArgumentException("Cannot set equilibrium");
            }

            @Override
            public void setParameterValueNotifyChangedAll(int n, double d) {
                throw new IllegalArgumentException("Cannot set equilibrium");
            }

            @Override
            public void addBounds(Bounds<Double> bounds) {
            }
        };
        return new FrequencyModel(this.dataType, proxy);
    }

    private static void checkDataType(DataType dataType) {
        for (int i = 1; i <= dataType.getStateCount(); ++i) {
            if (dataType.getState(Integer.toString(i)) == i - 1) continue;
            throw new IllegalArgumentException("Data type is not counting numbers.");
        }
    }

    private static enum BirthDeathParameterization {
        LINEAR{

            @Override
            double birthRate(int n, double[] dArray) {
                return (double)n * dArray[0];
            }

            @Override
            double deathRate(int n, double[] dArray) {
                return (double)n * dArray[1];
            }

            @Override
            int getRequiredDimension() {
                return 2;
            }
        }
        ,
        QUADRATIC{

            @Override
            double birthRate(int n, double[] dArray) {
                return (double)n * dArray[0] + (double)(n * n) * dArray[1];
            }

            @Override
            double deathRate(int n, double[] dArray) {
                return (double)n * dArray[2] + (double)(n * n) * dArray[3];
            }

            @Override
            int getRequiredDimension() {
                return 4;
            }
        };


        abstract double birthRate(int var1, double[] var2);

        abstract double deathRate(int var1, double[] var2);

        abstract int getRequiredDimension();
    }
}

