/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.Codons;

public enum CodonLabeling {
    SYN("S"),
    NON_SYN("N");

    private final String text;

    private CodonLabeling(String string2) {
        this.text = string2;
    }

    public String getText() {
        return this.text;
    }

    public static double[] getRegisterMatrix(CodonLabeling codonLabeling, Codons codons) {
        return CodonLabeling.getRegisterMatrix(codonLabeling, codons, false);
    }

    public static double[] getRegisterMatrix(CodonLabeling codonLabeling, Codons codons, boolean bl) {
        int n;
        int n2;
        int n3 = codons.getStateCount();
        int n4 = (n3 - 1) * n3 / 2;
        byte[] byArray = Codons.constructRateMap(n4, n3, codons, codons.getGeneticCode());
        double[] dArray = new double[n3 * n3];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (n2 = i + 1; n2 < n3; ++n2) {
                n = byArray[n5];
                if (codonLabeling == SYN && (n == 1 || n == 2) || codonLabeling == NON_SYN && (n == 3 || n == 4)) {
                    dArray[i * n3 + n2] = 1.0;
                    dArray[n2 * n3 + i] = 1.0;
                }
                ++n5;
            }
        }
        if (bl) {
            double[] dArray2 = dArray;
            dArray = new double[4096];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    if (dArray2[n2 * n3 + n] != 1.0) continue;
                    dArray[codons.getCanonicalState((int)n2) * 64 + codons.getCanonicalState((int)n)] = 1.0;
                }
            }
        }
        return dArray;
    }

    public static CodonLabeling parseFromString(String string) {
        for (CodonLabeling codonLabeling : CodonLabeling.values()) {
            if (codonLabeling.getText().compareToIgnoreCase(string) != 0) continue;
            return codonLabeling;
        }
        return null;
    }
}

