/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.Codons;
import dr.evomodel.substmodel.AbstractPCARateMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class PCARateMatrixMammalia
extends AbstractPCARateMatrix {
    public static final String FREQS_FILE = "freqs.csv";
    public static final String SCALES_FILE = "scales.csv";
    public static final String MEANS_FILE = "means.csv";
    public static final String FACTORS_FILE = "startfacs.csv";
    public static final String PCS_FILE = "pcs.csv";

    public PCARateMatrixMammalia(int n, String string) {
        super("mammalia", Codons.UNIVERSAL, string);
        this.setupMeans();
        this.setupFreqs();
        this.setupScales();
        this.setupStartFacs();
        this.setupPCs(n);
    }

    private void setupFreqs() {
        double[] dArray = this.readSingleArray(FREQS_FILE, 61);
        this.setFrequencies(dArray);
    }

    private void setupScales() {
        double[] dArray = this.readSingleArray(SCALES_FILE, 1830);
        this.setScales(dArray);
    }

    private void setupMeans() {
        double[] dArray = this.readSingleArray(MEANS_FILE, 1830);
        this.setMeans(dArray);
    }

    private void setupStartFacs() {
        double[] dArray = this.readSingleArray(FACTORS_FILE, 1830);
        this.setStartFacs(dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPCs(int n) {
        double[][] dArray = new double[n][1830];
        File file = new File(dataDir, PCS_FILE);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            int n2 = 0;
            for (int i = 0; (string = bufferedReader.readLine()) != null && i < n; ++i) {
                n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    dArray[i][n2] = Double.valueOf(stringTokenizer.nextToken());
                    ++n2;
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Caught FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("Caught IOException: " + iOException.getMessage());
        }
        this.setPCs(dArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] readSingleArray(String string, int n) {
        File file = new File(dataDir, string);
        double[] dArray = new double[n];
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    dArray[n2] = Double.valueOf(stringTokenizer.nextToken());
                    ++n2;
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Caught FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("Caught IOException: " + iOException.getMessage());
        }
        return dArray;
    }
}

