/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.app.beauti.components.BeautiModelIDProvider;
import dr.app.beauti.components.BeautiParameterIDProvider;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.continuous.IntegratedFactorAnalysisLikelihood;
import dr.evomodelxml.treelikelihood.TreeTraitParserUtilities;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.util.TaskPool;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IntegratedFactorAnalysisLikelihoodParser
extends AbstractXMLObjectParser
implements BeautiModelIDProvider {
    public static final String INTEGRATED_FACTOR_Model = "integratedFactorModel";
    public static final String LOADINGS = "loadings";
    public static final String PRECISION = "precision";
    private static final String NUGGET = "nugget";
    private static final String CACHE_PRECISION = "cachePrecision";
    private static final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("loadings", new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)}), new ElementRule("precision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(MutableTreeModel.class), AttributeRule.newStringRule("traitName"), new ElementRule("traitParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("missingIndicator", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), AttributeRule.newDoubleRule("nugget", true), AttributeRule.newBooleanRule("standardize", true), new ElementRule(TaskPool.class, true), AttributeRule.newDoubleRule("targetSd", true), AttributeRule.newBooleanRule("cachePrecision", true)};
    private static final String[] ALLOWABLE_PARAMETERS = new String[]{"precision", "loadings"};

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        MutableTreeModel mutableTreeModel = (MutableTreeModel)xMLObject.getChild(MutableTreeModel.class);
        TreeTraitParserUtilities treeTraitParserUtilities = new TreeTraitParserUtilities();
        TreeTraitParserUtilities.TraitsAndMissingIndices traitsAndMissingIndices = treeTraitParserUtilities.parseTraitsFromTaxonAttributes(xMLObject, (Tree)mutableTreeModel, true);
        CompoundParameter compoundParameter = traitsAndMissingIndices.traitParameter;
        boolean[] blArray = traitsAndMissingIndices.getMissingIndicators();
        MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getElementFirstChild(LOADINGS);
        Parameter parameter = (Parameter)xMLObject.getElementFirstChild(PRECISION);
        double d = xMLObject.getAttribute(NUGGET, 0.0);
        TaskPool taskPool = (TaskPool)xMLObject.getChild(TaskPool.class);
        boolean bl = xMLObject.getAttribute(CACHE_PRECISION, false);
        IntegratedFactorAnalysisLikelihood.CacheProvider cacheProvider = bl ? IntegratedFactorAnalysisLikelihood.CacheProvider.USE_CACHE : IntegratedFactorAnalysisLikelihood.CacheProvider.NO_CACHE;
        return new IntegratedFactorAnalysisLikelihood(xMLObject.getId(), compoundParameter, blArray, matrixParameterInterface, parameter, d, taskPool, cacheProvider);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return rules;
    }

    @Override
    public String getParserDescription() {
        return null;
    }

    @Override
    public Class getReturnType() {
        return IntegratedFactorAnalysisLikelihood.class;
    }

    @Override
    public String getParserName() {
        return INTEGRATED_FACTOR_Model;
    }

    @Override
    public String getParserTag() {
        return this.getParserName();
    }

    @Override
    public String getId(String string) {
        return string + ".integratedFactorModel";
    }

    @Override
    public BeautiParameterIDProvider getBeautiParameterIDProvider(String string) {
        for (int i = 0; i < ALLOWABLE_PARAMETERS.length; ++i) {
            if (!string.equalsIgnoreCase(ALLOWABLE_PARAMETERS[i])) continue;
            if (string.equalsIgnoreCase(PRECISION)) {
                string = "residualPrecision";
            }
            return new BeautiParameterIDProvider(string);
        }
        throw new IllegalArgumentException("Unrecognized parameter key '" + string + "'");
    }
}

