/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.tree.LineageCountThroughTime;
import dr.stats.Variate;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class LineageCountThroughTimeParser
extends AbstractXMLObjectParser {
    public static final String TREE_FILE = "treeFile";
    public static final String MIN_TIME = "minTime";
    public static final String MAX_TIME = "maxTime";
    public static final String BIN_COUNT = "binCount";
    public static final String SKIP = "skip";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("treeFile", false, "A tree file to calculate the average lineage count through time plot."), AttributeRule.newIntegerRule("skip", true, "The number of trees to skip at start of file."), AttributeRule.newIntegerRule("binCount", true, "The number of bins to use in lineage count through time plot."), AttributeRule.newDoubleRule("minTime", true, "The min time to compute lineage count from."), AttributeRule.newDoubleRule("maxTime", false, "The max time to compute lineage count to.")};

    @Override
    public String getParserName() {
        return "lineageCountThroughTime";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        if (xMLObject.getChildCount() > 0) {
            throw new XMLParseException("No child elements allowed in location element.");
        }
        int n = xMLObject.getAttribute(BIN_COUNT, 100);
        int n2 = xMLObject.getAttribute(SKIP, 0);
        double d = xMLObject.getAttribute(MIN_TIME, 0.0);
        double d2 = xMLObject.getAttribute(MAX_TIME, 1.0);
        String string = xMLObject.getAttribute(TREE_FILE, "");
        try {
            Variate[] variateArray = LineageCountThroughTime.getLTT(string, d, d2, n, n2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Time\tLineage_Count\n");
            for (int i = 0; i < variateArray[0].getCount(); ++i) {
                stringBuilder.append(variateArray[0].get(i));
                stringBuilder.append("\t");
                stringBuilder.append(variateArray[1].get(i));
                stringBuilder.append("\n");
            }
            String string2 = stringBuilder.toString();
            System.out.println();
            System.out.println(string2);
            return string2;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String getParserDescription() {
        return "Specifies a location with an optional longitude and latitude";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Class getReturnType() {
        return String.class;
    }
}

