/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.inference.model.Parameter;
import dr.inference.model.PearsonCorrelation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PearsonCorrelationParser
extends AbstractXMLObjectParser {
    public static final String PEARSON_CORRELATION = "pearsonCorrelation";
    public static final String LOG = "log";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 2, 2), AttributeRule.newBooleanRule("log", true)};

    @Override
    public String getParserName() {
        return PEARSON_CORRELATION;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        boolean bl = xMLObject.getAttribute(LOG, false);
        Parameter parameter = (Parameter)xMLObject.getChild(0);
        Parameter parameter2 = (Parameter)xMLObject.getChild(1);
        PearsonCorrelation pearsonCorrelation = new PearsonCorrelation(parameter, parameter2, bl);
        return pearsonCorrelation;
    }

    @Override
    public String getParserDescription() {
        return "A Pearson Correlation between two Parameters";
    }

    @Override
    public String getExample() {
        return "<pearsonCorrelation id=\"r\" log=\"true\">\n\t<parameter idref=\"param1\"/>\n    <parameter idref=\"param2\"/>\n</pearsonCorrelation>\n";
    }

    @Override
    public Class getReturnType() {
        return PearsonCorrelation.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

