/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.GeoSpatialDistribution;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManyUniformGeoDistributionModel
extends AbstractModelLikelihood {
    private final List<Parameter> parameters;
    private final List<GeoSpatialDistribution> distributions;
    private final List<Likelihood> oldLikelihoods;
    private final int count;
    private final Map<Parameter, Integer> parameterMap;
    private boolean[] likelihoodKnown;
    private boolean[] storedLikelihoodKnown;
    private double[] likelihood;
    private double[] storedLikelihood;
    private boolean allLikelihoodsKnown = false;
    private boolean storedAllLikelihoodsKnown;
    private double logLikelihood;
    private double storedLogLikelihood;

    public ManyUniformGeoDistributionModel(String string, List<Parameter> list, List<GeoSpatialDistribution> list2) {
        this(string, list, list2, null);
    }

    public ManyUniformGeoDistributionModel(String string, List<Parameter> list, List<GeoSpatialDistribution> list2, List<Likelihood> list3) {
        super(string);
        assert (list.size() == list2.size());
        this.count = list.size();
        this.parameters = list;
        this.distributions = list2;
        this.oldLikelihoods = list3;
        this.parameterMap = new HashMap<Parameter, Integer>(this.count);
        this.likelihood = new double[this.count];
        this.storedLikelihood = new double[this.count];
        this.likelihoodKnown = new boolean[this.count];
        this.storedLikelihoodKnown = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            Parameter parameter = list.get(i);
            this.addVariable(parameter);
            this.parameterMap.put(parameter, i);
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.allLikelihoodsKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.allLikelihoodsKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.allLikelihoodsKnown = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        if (this.oldLikelihoods == null) {
            return new HashSet<Likelihood>(Arrays.asList(this));
        }
        HashSet<Likelihood> hashSet = new HashSet<Likelihood>(this.oldLikelihoods);
        hashSet.add(this);
        return hashSet;
    }

    @Override
    protected void storeState() {
        this.storedAllLikelihoodsKnown = this.allLikelihoodsKnown;
        this.storedLogLikelihood = this.logLikelihood;
        System.arraycopy(this.likelihood, 0, this.storedLikelihood, 0, this.count);
        System.arraycopy(this.likelihoodKnown, 0, this.storedLikelihoodKnown, 0, this.count);
    }

    @Override
    protected void restoreState() {
        this.allLikelihoodsKnown = this.storedAllLikelihoodsKnown;
        this.logLikelihood = this.storedLogLikelihood;
        double[] dArray = this.likelihood;
        this.likelihood = this.storedLikelihood;
        this.storedLikelihood = dArray;
        boolean[] blArray = this.likelihoodKnown;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.storedLikelihoodKnown = blArray;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (variable instanceof Parameter);
        int n2 = this.parameterMap.get(variable);
        this.likelihoodKnown[n2] = false;
        this.allLikelihoodsKnown = false;
    }

    private double calculateLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            if (!this.likelihoodKnown[i]) {
                this.likelihood[i] = this.distributions.get(i).logPdf(this.parameters.get(i).getParameterValues());
                this.likelihoodKnown[i] = true;
            }
            d += this.likelihood[i];
        }
        return d;
    }
}

