/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.Binomial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinomialLikelihood
extends AbstractModelLikelihood {
    public static final String BINOMIAL_LIKELIHOOD = "binomialLikelihood";
    Parameter trialsParameter;
    Parameter proportionParameter;
    Parameter countsParameter;
    private final boolean onLogitScale;

    public BinomialLikelihood(Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl) {
        super(BINOMIAL_LIKELIHOOD);
        this.trialsParameter = parameter;
        this.proportionParameter = parameter2;
        this.countsParameter = parameter3;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        this.onLogitScale = bl;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        SufficientStatistics sufficientStatistics = new SufficientStatistics(this.proportionParameter.getParameterValue(0), this.onLogitScale);
        if (sufficientStatistics.outOfBounds) {
            return Double.NEGATIVE_INFINITY;
        }
        boolean bl = this.proportionParameter.getDimension() > 1;
        double d = 0.0;
        for (int i = 0; i < this.trialsParameter.getDimension(); ++i) {
            if (bl && i > 0) {
                sufficientStatistics = new SufficientStatistics(this.proportionParameter.getParameterValue(i), this.onLogitScale);
                if (sufficientStatistics.outOfBounds) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            int n = (int)Math.round(this.trialsParameter.getParameterValue(i));
            int n2 = (int)Math.round(this.countsParameter.getParameterValue(i));
            if (n2 > n) {
                return Double.NEGATIVE_INFINITY;
            }
            d += this.binomialLogLikelihood(n, n2, sufficientStatistics.logP, sufficientStatistics.log1MinusP);
        }
        return d;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    private double binomialLogLikelihood(int n, int n2, double d, double d2) {
        return Binomial.logChoose(n, n2) + d * (double)n2 + d2 * (double)(n - n2);
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    class SufficientStatistics {
        double logP;
        double log1MinusP;
        boolean outOfBounds;

        SufficientStatistics(double d, boolean bl) {
            if (bl) {
                double d2 = Math.log(1.0 + Math.exp(d));
                this.logP = d - d2;
                this.log1MinusP = -d2;
                this.outOfBounds = false;
            } else {
                this.logP = Math.log(d);
                this.log1MinusP = Math.log(1.0 - d);
                this.outOfBounds = d <= 0.0 || d >= 1.0;
            }
        }
    }
}

