/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public class CachedDistributionLikelihood
extends AbstractModelLikelihood {
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnow;
    private double logLikelihood;
    private double storedLogLikelihood;
    private final AbstractDistributionLikelihood likelihood;

    public CachedDistributionLikelihood(String string, AbstractDistributionLikelihood abstractDistributionLikelihood, Variable variable) {
        super(string);
        this.likelihood = abstractDistributionLikelihood;
        this.addVariable(variable);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnow = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnow;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    public AbstractDistributionLikelihood getDistributionLikelihood() {
        return this.likelihood;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    private double calculateLogLikelihood() {
        return this.likelihood.calculateLogLikelihood();
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }
}

