/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.CauchyDistribution;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;

public class CauchyDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider {
    private final Variable<Double> median;
    private final Variable<Double> scale;

    public CauchyDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        super("normalDistributionModel");
        this.median = variable;
        this.scale = variable2;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    private double getScale() {
        return this.scale.getValue(0);
    }

    private double getMedian() {
        return this.median.getValue(0);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.median;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = CauchyDistribution.gradLogPdf(dArray[i], this.getMedian(), this.getScale());
        }
        return dArray2;
    }

    @Override
    public double pdf(double d) {
        return CauchyDistribution.pdf(d, this.getMedian(), this.getScale());
    }

    @Override
    public double logPdf(double d) {
        return CauchyDistribution.logPdf(d, this.getMedian(), this.getScale());
    }

    @Override
    public double cdf(double d) {
        return CauchyDistribution.cdf(d, this.getMedian(), this.getScale());
    }

    @Override
    public double quantile(double d) {
        return CauchyDistribution.quantile(d, this.getMedian(), this.getScale());
    }

    @Override
    public double mean() {
        return Double.NaN;
    }

    @Override
    public double variance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        CauchyDistribution cauchyDistribution = new CauchyDistribution(this.getMedian(), this.getScale());
        return cauchyDistribution.getProbabilityDensityFunction();
    }
}

