/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.Binomial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HierarchicalGraphLikelihood
extends AbstractModelLikelihood {
    public static final String HIERARCHICAL_GRAPH_LIKELIHOOD = "hierarchicalGraphLikelihood";
    Parameter hierarchicalIndicator;
    MatrixParameter strataIndicatorMatrix;
    Parameter prob;

    public HierarchicalGraphLikelihood(Parameter parameter, MatrixParameter matrixParameter, Parameter parameter2) {
        super(HIERARCHICAL_GRAPH_LIKELIHOOD);
        this.hierarchicalIndicator = parameter;
        this.strataIndicatorMatrix = matrixParameter;
        this.prob = parameter2;
        this.addVariable(parameter);
        this.addVariable(matrixParameter);
        this.addVariable(parameter2);
    }

    public Parameter getHierarchicalIndicator() {
        return this.hierarchicalIndicator;
    }

    public MatrixParameter getStrataMatrix() {
        return this.strataIndicatorMatrix;
    }

    public Parameter getProb() {
        return this.prob;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.prob.getParameterValue(0);
        if (d <= 0.0 || d >= 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = Math.log(d);
        double d3 = Math.log(1.0 - d);
        if (this.hierarchicalIndicator.getDimension() != this.strataIndicatorMatrix.getRowDimension()) {
            return Double.NEGATIVE_INFINITY;
        }
        double d4 = 0.0;
        for (int i = 0; i < this.strataIndicatorMatrix.getColumnDimension(); ++i) {
            int n = 0;
            for (int j = 0; j < this.hierarchicalIndicator.getDimension(); ++j) {
                n += (int)Math.abs(Math.round(this.hierarchicalIndicator.getParameterValue(j) - this.strataIndicatorMatrix.getParameterValue(j, i)));
            }
            d4 += this.geometricLogLikelihood(n, d2, d3);
        }
        return d4;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    private double binomialLogLikelihood(int n, int n2, double d, double d2) {
        return Math.log(Binomial.choose(n, n2)) + d * (double)n2 + d2 * (double)(n - n2);
    }

    private double geometricLogLikelihood(int n, double d, double d2) {
        return d2 + d * (double)n;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }
}

