/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.MultivariateTraitDebugUtilities;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Statistic;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;
import java.util.Arrays;

public class BlombergKStatistic
extends Statistic.Abstract
implements ModelListener {
    public static final String BLOMBERGS_K = "blombergsK";
    private final TreeDataLikelihood traitLikelihood;
    private final TreeModel tree;
    private final TreeTrait treeTrait;
    private boolean needToUpdateTree = true;
    private final int traitDim;
    private Matrix Linv;
    private final int treeDim;
    private double expectedRatio;
    private final ContinuousDataLikelihoodDelegate delegate;
    private final double[] k;

    public BlombergKStatistic(TreeDataLikelihood treeDataLikelihood, String string) {
        this.traitLikelihood = treeDataLikelihood;
        this.tree = (TreeModel)treeDataLikelihood.getTree();
        this.tree.addModelListener(this);
        this.treeTrait = treeDataLikelihood.getTreeTrait(string);
        this.traitDim = treeDataLikelihood.getDataLikelihoodDelegate().getTraitDim();
        this.treeDim = this.tree.getTaxonCount();
        this.delegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.k = new double[this.traitDim];
    }

    @Override
    public int getDimension() {
        return this.traitDim;
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.computeStatistics();
        }
        return this.k[n];
    }

    public void computeStatistics() {
        double d;
        double d2;
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        if (this.needToUpdateTree) {
            Object object4;
            object3 = MultivariateTraitDebugUtilities.getTreeVariance(this.tree, this.traitLikelihood.getBranchRateModel(), 1.0, Double.POSITIVE_INFINITY);
            object2 = new SymmetricMatrix((double[][])object3);
            try {
                object4 = new CholeskyDecomposition((Matrix)object2);
                object = new Matrix(((CholeskyDecomposition)object4).getL());
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
                throw new RuntimeException();
            }
            this.Linv = ((Matrix)object).inverse().transpose();
            object4 = new double[this.treeDim];
            Arrays.fill((double[])object4, 1.0);
            try {
                vector = this.Linv.product(new Vector((double[])object4));
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
                throw new RuntimeException();
            }
            d2 = 0.0;
            for (int i = 0; i < this.treeDim; ++i) {
                d2 += vector.component(i) * vector.component(i);
            }
            d = 0.0;
            for (int i = 0; i < this.treeDim; ++i) {
                d += object3[i][i];
            }
            this.expectedRatio = (d - (double)this.treeDim / d2) / (double)(this.treeDim - 1);
            this.needToUpdateTree = false;
        }
        object3 = (double[])this.treeTrait.getTrait(this.tree, null);
        object2 = this.delegate.getPostOrderRootMean();
        object = new double[this.treeDim];
        for (int i = 0; i < this.traitDim; ++i) {
            for (int j = 0; j < this.treeDim; ++j) {
                object[j] = object3[j * this.traitDim + i] - object2[i];
            }
            try {
                vector = this.Linv.product(new Vector((double[])object));
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
                throw new RuntimeException();
            }
            d2 = this.sumSquares((double[])object);
            d = this.sumSquares(vector.toComponents());
            this.k[i] = d2 / d / this.expectedRatio;
        }
    }

    private double sumSquares(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        this.needToUpdateTree = true;
    }

    @Override
    public void modelRestored(Model model) {
        this.needToUpdateTree = true;
    }
}

