/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;

public class DifferenceStatistic
extends Statistic.Abstract {
    private final boolean absolute;
    private int dimension = 0;
    private Statistic term1 = null;
    private Statistic term2 = null;

    public DifferenceStatistic(String string, Statistic statistic, Statistic statistic2, boolean bl) {
        super(string);
        this.term1 = statistic;
        this.term2 = statistic2;
        if (statistic.getDimension() != 1 && statistic2.getDimension() != 1 && statistic.getDimension() != statistic2.getDimension()) {
            throw new IllegalArgumentException();
        }
        this.dimension = statistic2.getDimension() == 1 ? statistic.getDimension() : statistic2.getDimension();
        this.absolute = bl;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double getStatisticValue(int n) {
        double d = this.term1.getDimension() == 1 ? this.term1.getStatisticValue(0) - this.term2.getStatisticValue(n) : (this.term2.getDimension() == 1 ? this.term1.getStatisticValue(n) - this.term1.getStatisticValue(0) : this.term1.getStatisticValue(n) - this.term2.getStatisticValue(n));
        if (this.absolute) {
            d = Math.abs(d);
        }
        return d;
    }
}

