/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.util.Identifiable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface Likelihood
extends Loggable,
Identifiable {
    public static final Set<Likelihood> FULL_LIKELIHOOD_SET = new HashSet<Likelihood>();
    public static final Set<Likelihood> CONNECTED_LIKELIHOOD_SET = new HashSet<Likelihood>();

    public Model getModel();

    public double getLogLikelihood();

    public void makeDirty();

    public String prettyName();

    public Set<Likelihood> getLikelihoodSet();

    public boolean isUsed();

    public void setUsed();

    public boolean evaluateEarly();

    public static abstract class Abstract
    implements Likelihood,
    ModelListener {
        private String id = null;
        private final Model model;
        private double logLikelihood;
        private boolean likelihoodKnown = false;
        private boolean used = false;

        public Abstract(Model model) {
            this.model = model;
            if (model != null) {
                model.addModelListener(this);
            }
        }

        @Override
        public void modelChangedEvent(Model model, Object object, int n) {
            this.makeDirty();
        }

        @Override
        public void modelRestored(Model model) {
            this.makeDirty();
        }

        @Override
        public Model getModel() {
            return this.model;
        }

        @Override
        public final double getLogLikelihood() {
            if (!this.getLikelihoodKnown()) {
                this.logLikelihood = this.calculateLogLikelihood();
                this.likelihoodKnown = true;
            }
            return this.logLikelihood;
        }

        @Override
        public void makeDirty() {
            this.likelihoodKnown = false;
        }

        protected boolean getLikelihoodKnown() {
            return this.likelihoodKnown;
        }

        protected abstract double calculateLogLikelihood();

        @Override
        public Set<Likelihood> getLikelihoodSet() {
            return new HashSet<Likelihood>(Arrays.asList(this));
        }

        public String toString() {
            return this.getClass().getName() + "(" + (this.getLikelihoodKnown() ? Double.valueOf(this.logLikelihood) : "??") + ")";
        }

        public static String getPrettyName(Likelihood likelihood) {
            Model model = likelihood.getModel();
            String string = likelihood.getClass().getName();
            String[] stringArray = string.split("\\.");
            string = stringArray[stringArray.length - 1];
            if (model != null) {
                String string2 = model.getModelName();
                String string3 = model.getId();
                string = string + "(" + string2;
                if (string3 != null && !string3.equals(string2)) {
                    string = string + '[' + string3 + ']';
                }
                string = string + ")";
            }
            return string;
        }

        @Override
        public String prettyName() {
            return Abstract.getPrettyName(this);
        }

        @Override
        public boolean isUsed() {
            return this.used;
        }

        @Override
        public void setUsed() {
            this.used = true;
        }

        @Override
        public boolean evaluateEarly() {
            return false;
        }

        @Override
        public LogColumn[] getColumns() {
            return new LogColumn[]{new LikelihoodColumn(this.getId())};
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public String getId() {
            return this.id;
        }

        private class LikelihoodColumn
        extends NumberColumn {
            public LikelihoodColumn(String string) {
                super(string);
            }

            @Override
            public double getDoubleValue() {
                return Abstract.this.getLogLikelihood();
            }
        }
    }
}

