/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.BooleanStatistic;
import dr.inference.model.Statistic;
import java.util.List;

public class NotBooleanStatistic
extends Statistic.Abstract
implements BooleanStatistic {
    private final BooleanStatistic originalStatistic;
    private final List<Integer> mark;

    public NotBooleanStatistic(BooleanStatistic booleanStatistic) {
        this(booleanStatistic, null);
    }

    public NotBooleanStatistic(BooleanStatistic booleanStatistic, List<Integer> list) {
        super(booleanStatistic.getStatisticName());
        this.originalStatistic = booleanStatistic;
        this.mark = list;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        boolean bl = this.originalStatistic.getBoolean(n);
        if (this.mark == null || this.mark.contains(n)) {
            bl = !bl;
        }
        return bl;
    }

    @Override
    public int getDimension() {
        return this.originalStatistic.getDimension();
    }
}

