/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling;

import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingLayout;

public class NativeMDSSingleton {
    private static final String LIBRARY_NAME = "mds2_jni";
    private static final String LIBRARY_PATH_LABEL = "mds.library.path";
    private static final String LIBRARY_PLATFORM_NAME = NativeMDSSingleton.getPlatformSpecificLibraryName();
    private static final String LIBRARY_PLATFORM_EXTENSION = NativeMDSSingleton.getPlatformSpecificLibraryExtension();
    private static final String LIBRARY_PLATFORM_PREFIX = NativeMDSSingleton.getPlatformSpecificLibraryPrefix();
    static final String THREADS = "mds.threads";
    static final String MDS_RESOURCE = "mds.resource";
    private static NativeMDSSingleton INSTANCE = null;

    private NativeMDSSingleton() {
    }

    private static String getPlatformSpecificLibraryName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows")) {
            if (string2.equals("x86") || string2.equals("i386")) {
                return "mds2_jni32";
            }
            if (string2.startsWith("amd64") || string2.startsWith("x86_64")) {
                return "mds2_jni64";
            }
        }
        return LIBRARY_NAME;
    }

    private static String getPlatformSpecificLibraryExtension() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            return ".dll";
        }
        if (string.startsWith("mac")) {
            return ".dylib";
        }
        return ".so";
    }

    private static String getPlatformSpecificLibraryPrefix() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            return "";
        }
        return "lib";
    }

    public static NativeMDSSingleton loadLibrary() throws UnsatisfiedLinkError {
        if (INSTANCE == null) {
            System.err.println("Trying to load MDS library...");
            String string = "";
            if (System.getProperty(LIBRARY_PATH_LABEL) != null) {
                string = System.getProperty(LIBRARY_PATH_LABEL);
                if (string.length() > 0 && !string.endsWith("/")) {
                    string = string + "/";
                }
                System.load(string + LIBRARY_PLATFORM_PREFIX + LIBRARY_NAME + LIBRARY_PLATFORM_EXTENSION);
            } else {
                System.loadLibrary(LIBRARY_PLATFORM_NAME);
            }
            INSTANCE = new NativeMDSSingleton();
            System.err.println("MDS library loaded.");
        }
        return INSTANCE;
    }

    public int initialize(int n, MultiDimensionalScalingLayout multiDimensionalScalingLayout, MultiDimensionalScalingCore.CoreInformation coreInformation) {
        if (multiDimensionalScalingLayout.isSymmetric()) {
            return this.initialize(n, multiDimensionalScalingLayout.rowLocationCount, coreInformation);
        }
        return this.initialize(n, multiDimensionalScalingLayout.rowLocationCount, multiDimensionalScalingLayout.columnLocationCount, coreInformation.flags, coreInformation.deviceNumber, coreInformation.numThreads);
    }

    public int initialize(int n, int n2, MultiDimensionalScalingCore.CoreInformation coreInformation) {
        return this.initialize(n, n2, coreInformation.flags, coreInformation.deviceNumber, coreInformation.numThreads);
    }

    private native int initialize(int var1, int var2, long var3, int var5, int var6);

    private native int initialize(int var1, int var2, int var3, long var4, int var6, int var7);

    public native void updateLocations(int var1, int var2, double[] var3);

    public native double getSumOfIncrements(int var1);

    public native void storeState(int var1);

    public native void restoreState(int var1);

    public native void acceptState(int var1);

    public native void makeDirty(int var1);

    public native void setPairwiseData(int var1, double[] var2);

    public native void setParameters(int var1, double[] var2);

    public native double[] getPairwiseData(int var1);

    public native void getLocationGradient(int var1, double[] var2);

    public native void getObservationGradient(int var1, double[] var2);

    public native int getInternalDimension(int var1);

    public class ResourceDetails {
        private final int number;
        private String name;
        private String description;
        private long flags;

        public ResourceDetails(int n) {
            this.number = n;
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public long getFlags() {
            return this.flags;
        }

        public void setFlags(long l) {
            this.flags = l;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("").append(this.getNumber()).append(" : ").append(this.getName()).append("\n");
            if (this.getDescription() != null) {
                stringBuilder.append("    ").append(this.getDescription());
            }
            stringBuilder.append("    Flags:");
            stringBuilder.append(this.getFlags());
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

