/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Likelihood;
import dr.inference.model.Variable;
import dr.inference.operators.SliceOperator;
import dr.math.MathUtils;

public interface SliceInterval {
    public double drawFromInterval(Likelihood var1, double var2, double var4);

    public void setSliceSampler(SliceOperator var1);

    public static class Doubling
    extends Abstract {
        @Override
        public Abstract.Interval constructInterval(Likelihood likelihood, double d, double d2, double d3) {
            return new Abstract.Interval(0.0, 1.0);
        }

        @Override
        protected boolean test(Likelihood likelihood, double d, double d2, double d3, double d4) {
            return true;
        }
    }

    public static class SteppingOut
    extends Abstract {
        private int m;

        public SteppingOut() {
            this(10);
        }

        public SteppingOut(int n) {
            this.m = n;
        }

        @Override
        public Abstract.Interval constructInterval(Likelihood likelihood, double d, double d2, double d3) {
            int n;
            double d4 = d - d3 * MathUtils.nextDouble();
            double d5 = d4 + d3;
            int n2 = this.m - 1 - n;
            for (n = MathUtils.nextInt(this.m); n > 0 && d2 < this.evaluate(likelihood, d4); --n) {
                d4 -= d3;
            }
            while (n2 > 0 && d2 < this.evaluate(likelihood, d5)) {
                d5 += d3;
                --n2;
            }
            return new Abstract.Interval(d4, d5);
        }

        @Override
        protected boolean test(Likelihood likelihood, double d, double d2, double d3, double d4) {
            return true;
        }
    }

    public static abstract class Abstract
    implements SliceInterval {
        protected Variable<Double> variable;
        protected SliceOperator sliceSampler;

        @Override
        public double drawFromInterval(Likelihood likelihood, double d, double d2) {
            double d3 = this.variable.getValue(0);
            Interval interval = this.constructInterval(likelihood, d3, d, d2);
            double d4 = d3;
            boolean bl = false;
            while (!bl) {
                d4 = MathUtils.uniform(interval.lower, interval.upper);
                if (d < this.evaluate(likelihood, d4) && this.test(likelihood, d3, d4, d, d2)) {
                    bl = true;
                    continue;
                }
                this.shrinkInterval(interval, d3, d4);
            }
            return d4;
        }

        public abstract Interval constructInterval(Likelihood var1, double var2, double var4, double var6);

        protected abstract boolean test(Likelihood var1, double var2, double var4, double var6, double var8);

        public void shrinkInterval(Interval interval, double d, double d2) {
            if (d2 < d) {
                interval.lower = d2;
            } else {
                interval.upper = d2;
            }
        }

        @Override
        public void setSliceSampler(SliceOperator sliceOperator) {
            this.sliceSampler = sliceOperator;
            this.variable = sliceOperator.getVariable();
        }

        protected double evaluate(Likelihood likelihood, double d) {
            this.variable.setValue(0, d);
            return this.sliceSampler.evaluate(likelihood, 1.0);
        }

        protected class Interval {
            double lower;
            double upper;

            Interval(double d, double d2) {
                this.lower = d;
                this.upper = d2;
            }
        }
    }
}

