/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.ReversibleHMCProvider;
import dr.inference.operators.hmc.SplitHMCtravelTimeMultiplier;
import dr.math.AdaptableCovariance;
import dr.math.matrixAlgebra.Lanczos;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;

class LeastEigenvalueRatioSCM
implements SplitHMCtravelTimeMultiplier {
    ReversibleHMCProvider inner;
    ReversibleHMCProvider outer;
    AdaptableCovariance adaptableCovarianceInner;
    AdaptableCovariance adaptableCovarianceOuter;
    double[] maskVectorInner;
    double[] maskVectorOuter;
    SplitHMCtravelTimeMultiplier.RSoptions rsOptions;

    public LeastEigenvalueRatioSCM(ReversibleHMCProvider reversibleHMCProvider, ReversibleHMCProvider reversibleHMCProvider2, SplitHMCtravelTimeMultiplier.RSoptions rSoptions) {
        this.inner = reversibleHMCProvider;
        this.outer = reversibleHMCProvider2;
        this.rsOptions = rSoptions;
        this.adaptableCovarianceInner = new AdaptableCovariance(reversibleHMCProvider.getInitialPosition().length);
        this.adaptableCovarianceOuter = new AdaptableCovariance(reversibleHMCProvider2.getInitialPosition().length);
        this.maskVectorInner = reversibleHMCProvider.getMask();
        this.maskVectorOuter = reversibleHMCProvider2.getMask();
    }

    @Override
    public double getMultiplier() {
        double d = LeastEigenvalueRatioSCM.getMinEigValueLanczos(this.adaptableCovarianceInner, this.maskVectorInner);
        double d2 = LeastEigenvalueRatioSCM.getMinEigValueLanczos(this.adaptableCovarianceOuter, this.maskVectorOuter);
        return Math.sqrt(d / d2);
    }

    static ReadableMatrix subsetByMask(ReadableMatrix readableMatrix, double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n = (int)((double)n + dArray[i]);
        }
        if (n < 2) {
            throw new RuntimeException("not a matrix!");
        }
        double[][] dArray2 = new double[n][n];
        int n2 = 0;
        for (int i = 0; i < readableMatrix.getMajorDim(); ++i) {
            int n3 = 0;
            boolean bl = true;
            for (int j = 0; j < readableMatrix.getMajorDim(); ++j) {
                if (dArray[i] != 1.0 || dArray[j] != 1.0) continue;
                bl = false;
                dArray2[n2][n3] = readableMatrix.get(i, j);
                ++n3;
            }
            if (bl) continue;
            ++n2;
        }
        return new WrappedMatrix.ArrayOfArray(dArray2);
    }

    static double getMinEigValueLanczos(AdaptableCovariance adaptableCovariance, double[] dArray) {
        int n;
        ReadableMatrix readableMatrix = dArray != null ? LeastEigenvalueRatioSCM.subsetByMask(adaptableCovariance.getCovariance(), dArray) : adaptableCovariance.getCovariance();
        double[] dArray2 = Lanczos.eigen(readableMatrix, n = readableMatrix.getMajorDim());
        if (dArray2.length < n) {
            throw new RuntimeException("called getMinEigValueSCM too early!");
        }
        return dArray2[n - 1];
    }

    @Override
    public void updateSCM(AdaptableCovariance adaptableCovariance, double[] dArray, long l) {
        if (this.shouldUpdateSCM(l)) {
            adaptableCovariance.update(new WrappedVector.Raw(dArray));
        }
    }

    @Override
    public AdaptableCovariance getInnerCov() {
        return this.adaptableCovarianceInner;
    }

    @Override
    public AdaptableCovariance getOuterCov() {
        return this.adaptableCovarianceOuter;
    }

    @Override
    public boolean shouldUpdateSCM(long l) {
        return this.rsOptions.updateRSfrequency > 0 && l % (long)this.rsOptions.updateRSfrequency == 0L && l > (long)this.rsOptions.updateRSdelay;
    }

    @Override
    public boolean shouldGetMultiplier(long l) {
        return this.rsOptions.getRSfrequency > 0 && l % (long)this.rsOptions.getRSfrequency == 0L && l > (long)this.rsOptions.getRSdelay;
    }
}

