/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.hmc.HamiltonianMonteCarloOperator;
import dr.inference.operators.hmc.MassPreconditioningOptions;

public interface MassPreconditionScheduler {
    public boolean shouldUpdatePreconditioning();

    public boolean shouldStoreSecant(double[] var1, double[] var2);

    public void forceUpdateCount();

    public static class UpdateByProbability
    extends Default {
        UpdateByProbability(HamiltonianMonteCarloOperator.Options options, AdaptableMCMCOperator adaptableMCMCOperator) {
            super(options, adaptableMCMCOperator);
        }
    }

    public static class Default
    implements MassPreconditionScheduler {
        private MassPreconditioningOptions options;
        private MCMCOperator operator;
        private int totalUpdates = 0;
        private long paramUpdateCount = 0L;
        private boolean useOperatorCount = true;

        Default(MassPreconditioningOptions massPreconditioningOptions, MCMCOperator mCMCOperator) {
            this.options = massPreconditioningOptions;
            this.operator = mCMCOperator;
        }

        @Override
        public boolean shouldUpdatePreconditioning() {
            long l = this.useOperatorCount ? this.operator.getCount() : this.paramUpdateCount;
            boolean bl = this.shouldUpdate(l);
            if (bl) {
                ++this.totalUpdates;
            }
            return bl;
        }

        protected boolean shouldUpdate(long l) {
            return this.options.preconditioningUpdateFrequency() > 0 && l % (long)this.options.preconditioningUpdateFrequency() == 0L && (this.options.preconditioningMaxUpdate() == 0 || this.totalUpdates < this.options.preconditioningMaxUpdate());
        }

        @Override
        public boolean shouldStoreSecant(double[] dArray, double[] dArray2) {
            return dArray != null && dArray2 != null;
        }

        @Override
        public void forceUpdateCount() {
            ++this.paramUpdateCount;
            this.useOperatorCount = false;
        }
    }

    public static class None
    implements MassPreconditionScheduler {
        @Override
        public boolean shouldUpdatePreconditioning() {
            return false;
        }

        @Override
        public boolean shouldStoreSecant(double[] dArray, double[] dArray2) {
            return false;
        }

        @Override
        public void forceUpdateCount() {
        }
    }

    public static enum Type {
        NONE("none"){

            @Override
            public MassPreconditionScheduler factory(MassPreconditioningOptions massPreconditioningOptions, MCMCOperator mCMCOperator) {
                return new None();
            }
        }
        ,
        DEFAULT("default"){

            @Override
            public MassPreconditionScheduler factory(MassPreconditioningOptions massPreconditioningOptions, MCMCOperator mCMCOperator) {
                return new Default(massPreconditioningOptions, mCMCOperator);
            }
        };

        private final String name;

        private Type(String string2) {
            this.name = string2;
        }

        public abstract MassPreconditionScheduler factory(MassPreconditioningOptions var1, MCMCOperator var2);

        public String getName() {
            return this.name;
        }

        public static Type parseFromString(String string) {
            for (Type type : Type.values()) {
                if (type.name.toLowerCase().compareToIgnoreCase(string) != 0) continue;
                return type;
            }
            return NONE;
        }
    }
}

