/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.parallel;

import dr.inference.loggers.Logger;
import dr.inference.model.AbstractModel;
import dr.inference.model.Likelihood;
import dr.inference.parallel.MPIServices;
import dr.inference.parallel.ServiceRequest;
import dr.util.Identifiable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import mpi.MPI;

public class MPILikelihoodRunner
implements Runnable,
Identifiable {
    public static final String PARALLEL_CALCULATOR = "parallelCalculator";
    boolean terminate = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Likelihood.class)};

        @Override
        public String getParserName() {
            return MPILikelihoodRunner.PARALLEL_CALCULATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Likelihood likelihood = (Likelihood)xMLObject.getChild(Likelihood.class);
            MPILikelihoodRunner mPILikelihoodRunner = new MPILikelihoodRunner("slave", likelihood);
            mPILikelihoodRunner.init();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                if (!(object instanceof Logger)) continue;
                arrayList.add(object);
            }
            Logger[] loggerArray = new Logger[arrayList.size()];
            arrayList.toArray(loggerArray);
            java.util.logging.Logger.getLogger("dr.inference").info("Creating the parallelCalculator chain:");
            mPILikelihoodRunner.init();
            return mPILikelihoodRunner;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an MPI-based likelihood calculator.";
        }

        @Override
        public Class getReturnType() {
            return MPILikelihoodRunner.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private String id;
    private int mpiRank;
    private int mpiSize;
    private final Likelihood likelihood;

    public MPILikelihoodRunner(String string, Likelihood likelihood) {
        this.id = string;
        this.likelihood = likelihood;
    }

    @Override
    public void run() {
        while (!this.terminate) {
            ServiceRequest serviceRequest = MPIServices.getRequest(0);
            switch (serviceRequest) {
                case calculateLikeliood: {
                    this.calculateLikelihood();
                    break;
                }
                case terminateProcess: {
                    this.terminateMe();
                }
            }
        }
    }

    private void calculateLikelihood() {
        AbstractModel abstractModel = (AbstractModel)this.likelihood.getModel();
        abstractModel.receiveState(0);
        this.likelihood.makeDirty();
        abstractModel.fireModelChanged();
        double d = this.likelihood.getLogLikelihood();
        MPIServices.sendDouble(d, 0);
    }

    private void terminateMe() {
        this.terminate = true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public void init() {
        this.mpiRank = MPI.COMM_WORLD.Rank();
        this.mpiSize = MPI.COMM_WORLD.Size();
    }

    public void finalize() {
        MPI.Finalize();
    }
}

