/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.regression;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.regression.RegressionJNIWrapper;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.LinkedList;
import java.util.Queue;

public class SelfControlledCaseSeries
extends AbstractModelLikelihood {
    public static final String SCCS_NAME = "selfControlledCaseSeries";
    public static final String FILE_NAME = "fileName";
    public static final String BETA = "beta";
    public static final String PRECISION = "precision";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName"), new ElementRule("beta", Parameter.class), new ElementRule("precision", Parameter.class)};

        @Override
        public String getParserName() {
            return SelfControlledCaseSeries.SCCS_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(SelfControlledCaseSeries.FILE_NAME);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(SelfControlledCaseSeries.BETA);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(SelfControlledCaseSeries.PRECISION);
            return new SelfControlledCaseSeries(xMLObject.getId(), string, parameter, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "Self-controlled case series design.";
        }

        @Override
        public Class getReturnType() {
            return SelfControlledCaseSeries.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final RegressionJNIWrapper regressionInterface;
    private final int instance;
    private final Parameter beta;
    private final Parameter precision;
    private double logSCCSLikelihood;
    private double logSCCSPrior;
    private double storedLogSCCSLikelihood;
    private double storedLogSCCSPrior;
    private boolean betaChanged;
    private boolean precisionChanged;
    private boolean storedBetaChanged;
    private boolean storedPrecisionChanged;
    private Queue<Integer> betaFlag = new LinkedList<Integer>();
    private boolean newMode = false;
    private double[] mode = null;
    private double storedPrecision;
    private static final boolean DEBUG_MODE = false;
    private static final boolean DEBUG_LAZY = false;

    public SelfControlledCaseSeries(String string, String string2, Parameter parameter, Parameter parameter2) {
        super(string);
        this.regressionInterface = RegressionJNIWrapper.loadLibrary();
        this.instance = this.regressionInterface.loadData(string2);
        this.regressionInterface.setPriorType(this.instance, 2);
        this.precision = parameter2;
        this.setPrecision();
        this.precisionChanged = true;
        int n = this.regressionInterface.getBetaSize(this.instance);
        if (n != parameter.getDimension()) {
            parameter.setDimension(n);
        }
        this.beta = parameter;
        double[] dArray = this.getMode();
        for (int i = 0; i < parameter.getDimension(); ++i) {
            parameter.setParameterValue(i, dArray[i]);
        }
        this.logSCCSLikelihood = this.regressionInterface.getLogLikelihood(this.instance);
        this.logSCCSPrior = this.regressionInterface.getLogPrior(this.instance);
        this.betaChanged = false;
        this.addVariable(parameter);
        this.addVariable(parameter2);
    }

    private void setPrecision() {
        this.regressionInterface.setHyperprior(this.instance, 1.0 / this.precision.getParameterValue(0));
    }

    public double[] getMode() {
        if (this.precisionChanged) {
            this.setPrecision();
            this.mode = null;
        }
        if (this.mode == null) {
            this.regressionInterface.findMode(this.instance);
            this.mode = new double[this.beta.getDimension()];
            for (int i = 0; i < this.beta.getDimension(); ++i) {
                this.mode[i] = this.regressionInterface.getBeta(this.instance, i);
            }
            this.betaChanged = true;
            this.newMode = true;
        }
        double[] dArray = new double[this.mode.length];
        System.arraycopy(this.mode, 0, dArray, 0, this.mode.length);
        return dArray;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.betaChanged = true;
            if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
                this.betaFlag.clear();
            } else {
                this.betaFlag.add(n);
            }
        } else if (variable == this.precision) {
            this.precisionChanged = true;
        } else {
            throw new IllegalArgumentException("Unknown variable in SCCS");
        }
    }

    @Override
    protected void storeState() {
        this.storedLogSCCSLikelihood = this.logSCCSLikelihood;
        this.storedLogSCCSPrior = this.logSCCSPrior;
        this.storedBetaChanged = this.betaChanged;
        this.storedPrecisionChanged = this.precisionChanged;
        this.storedPrecision = this.precision.getParameterValue(0);
    }

    @Override
    protected void restoreState() {
        this.logSCCSLikelihood = this.storedLogSCCSLikelihood;
        this.logSCCSPrior = this.storedLogSCCSPrior;
        this.betaChanged = this.storedBetaChanged;
        this.precisionChanged = this.storedPrecisionChanged;
    }

    @Override
    protected void acceptState() {
        if (this.storedPrecision != this.precision.getParameterValue(0)) {
            this.mode = null;
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.calculateLogLikelihood();
    }

    private double calculateLogLikelihood() {
        if (this.betaChanged) {
            if (this.betaFlag.isEmpty() || this.newMode) {
                this.regressionInterface.setBeta(this.instance, this.beta.getParameterValues());
                this.newMode = false;
            } else {
                while (!this.betaFlag.isEmpty()) {
                    int n = this.betaFlag.remove();
                    this.regressionInterface.setBeta(this.instance, n, this.beta.getParameterValue(n));
                }
            }
        }
        if (this.precisionChanged) {
            this.setPrecision();
        }
        if (this.betaChanged) {
            this.logSCCSLikelihood = this.regressionInterface.getLogLikelihood(this.instance);
        }
        if (this.betaChanged || this.precisionChanged) {
            this.logSCCSPrior = this.regressionInterface.getLogPrior(this.instance);
        }
        this.betaChanged = false;
        this.precisionChanged = false;
        double d = this.logSCCSLikelihood + this.logSCCSPrior;
        return d;
    }

    @Override
    public void makeDirty() {
        this.betaChanged = true;
        this.newMode = true;
        this.precisionChanged = true;
        this.regressionInterface.makeDirty(this.instance);
    }
}

