/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.TraceType;
import dr.math.MachineAccuracy;
import dr.stats.DiscreteStatistics;
import dr.stats.FrequencyCounter;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraceDistribution {
    private TraceType traceType;
    private Map<Integer, String> categoryLabelMap;
    private List<Integer> categoryOrder;
    private FrequencyCounter<Integer> frequencyCounter;
    private boolean isConstant;
    protected boolean hasGeometricMean = false;
    protected int size = 0;
    protected double minimum;
    protected double maximum;
    protected double mean;
    protected double median;
    protected double q1;
    protected double q3;
    protected double geometricMean;
    protected double stdError;
    protected double meanSquaredError;
    protected double variance;
    protected double cpdLower;
    protected double cpdUpper;
    protected double hpdLower;
    protected double hpdUpper;
    protected double hpdLowerCustom;
    protected double hpdUpperCustom;

    public TraceDistribution(List<Double> list, TraceType traceType) {
        this(list, traceType, false);
    }

    public TraceDistribution(List<Double> list, TraceType traceType, boolean bl) {
        this.traceType = traceType;
        this.isConstant = bl;
        assert (traceType != TraceType.CATEGORICAL) : "cant use this constructor with categorical data";
        this.initStatistics(list, 0.95);
    }

    public TraceDistribution(List<Double> list, Map<Integer, String> map, List<Integer> list2, boolean bl) {
        this.traceType = TraceType.CATEGORICAL;
        this.categoryLabelMap = map;
        this.categoryOrder = list2;
        this.isConstant = bl;
        this.initStatistics(list, 0.95);
    }

    private void initStatistics(List<Double> list, double d) {
        if (list.size() < 1) {
            throw new RuntimeException("There is no value sent to statistics calculation !");
        }
        if (this.traceType.isNumber()) {
            this.analyseDistributionNumeric(list, d);
        }
        if (this.traceType != TraceType.REAL) {
            this.analyseDistributionDiscrete(list, d);
        }
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public int getSize() {
        return this.size;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdError() {
        return this.stdError;
    }

    public boolean hasGeometricMean() {
        return this.hasGeometricMean;
    }

    public double getGeometricMean() {
        return this.geometricMean;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public double getMedian() {
        return this.median;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ3() {
        return this.q3;
    }

    public double getLowerHPD() {
        return this.hpdLower;
    }

    public double getUpperHPD() {
        return this.hpdUpper;
    }

    public double getLowerCPD() {
        return this.cpdLower;
    }

    public double getUpperCPD() {
        return this.cpdUpper;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getHpdLowerCustom() {
        return this.hpdLowerCustom;
    }

    public double getHpdUpperCustom() {
        return this.hpdUpperCustom;
    }

    public double getMeanSquaredError(double[] dArray, double d) {
        if (dArray == null) {
            throw new RuntimeException("Trace values not yet set");
        }
        if (this.traceType.isNumber()) {
            return DiscreteStatistics.meanSquaredError(dArray, d);
        }
        throw new RuntimeException("Require Real or Ordinal Trace Type in the Trace Distribution: " + this);
    }

    private void analyseDistributionNumeric(List<Double> list, double d) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i);
        }
        this.size = dArray.length;
        if (!this.isConstant) {
            this.minimum = Double.POSITIVE_INFINITY;
            this.maximum = Double.NEGATIVE_INFINITY;
            for (double d2 : dArray) {
                if (d2 < this.minimum) {
                    this.minimum = d2;
                }
                if (!(d2 > this.maximum)) continue;
                this.maximum = d2;
            }
            this.isConstant = MachineAccuracy.isSame(this.maximum, this.minimum);
        }
        if (this.isConstant) {
            this.mean = dArray[0];
            this.stdError = 0.0;
            this.variance = 0.0;
            this.minimum = this.maximum = dArray[0];
            return;
        }
        this.mean = DiscreteStatistics.mean(dArray);
        this.stdError = DiscreteStatistics.stdev(dArray);
        this.variance = DiscreteStatistics.variance(dArray);
        if (this.minimum > 0.0) {
            this.geometricMean = DiscreteStatistics.geometricMean(dArray);
            this.hasGeometricMean = true;
        }
        int[] nArray = new int[dArray.length];
        HeapSort.sort(dArray, nArray);
        this.median = DiscreteStatistics.quantile(0.5, dArray, nArray);
        this.cpdLower = DiscreteStatistics.quantile(0.025, dArray, nArray);
        this.cpdUpper = DiscreteStatistics.quantile(0.975, dArray, nArray);
        this.q1 = DiscreteStatistics.quantile(0.25, dArray, nArray);
        this.q3 = DiscreteStatistics.quantile(0.75, dArray, nArray);
        this.calculateHPDInterval(d, dArray, nArray);
        this.calculateHPDIntervalCustom(0.5, dArray, nArray);
    }

    private void calculateHPDInterval(double d, double[] dArray, int[] nArray) {
        double[] dArray2 = DiscreteStatistics.HPDInterval(d, dArray, nArray);
        this.hpdLower = dArray2[0];
        this.hpdUpper = dArray2[1];
    }

    private void calculateHPDIntervalCustom(double d, double[] dArray, int[] nArray) {
        double[] dArray2 = DiscreteStatistics.HPDInterval(d, dArray, nArray);
        this.hpdLowerCustom = dArray2[0];
        this.hpdUpperCustom = dArray2[1];
    }

    private void analyseDistributionDiscrete(List<Double> list, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Double d2 : list) {
            arrayList.add(d2.intValue());
        }
        if (this.size == 0) {
            this.size = arrayList.size();
        }
        this.frequencyCounter = this.getTraceType() == TraceType.CATEGORICAL ? new FrequencyCounter(arrayList, d) : new FrequencyCounter(arrayList);
    }

    public Set<Integer> getValueSet() {
        if (this.categoryOrder != null) {
            return new LinkedHashSet<Integer>(this.categoryOrder);
        }
        return new LinkedHashSet<Integer>(this.frequencyCounter.getUniqueValues());
    }

    public FrequencyCounter<Integer> getFrequencyCounter() {
        assert (this.traceType.isDiscrete());
        return this.frequencyCounter;
    }

    public Set<Integer> getCredibleSet() {
        return this.frequencyCounter.getCredibleSet();
    }

    public Set<Integer> getIncredibleSet() {
        return this.frequencyCounter.getIncredibleSet();
    }

    public String valueToString(int n) {
        if (this.categoryLabelMap != null) {
            return this.categoryLabelMap.get(n);
        }
        return Integer.toString(n);
    }

    public String setToString(Set<Integer> set) {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean bl = true;
        for (int n : set) {
            String string = this.valueToString(n);
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int getMode() {
        return this.frequencyCounter.getMode();
    }

    public int getFrequencyOfMode() {
        return this.frequencyCounter.getFrequency(this.getMode());
    }

    public double getProbabilityOfMode() {
        if (this.getSize() > 0) {
            return (double)this.getFrequencyOfMode() / (double)this.getSize();
        }
        return 0.0;
    }

    public List<String> getRange() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : this.frequencyCounter.getUniqueValues()) {
            if (this.traceType.isInteger()) {
                if (arrayList.contains(Integer.toString(n))) continue;
                arrayList.add(Integer.toString(n));
                continue;
            }
            if (arrayList.contains(n.toString())) continue;
            arrayList.add(n.toString());
        }
        return arrayList;
    }
}

