/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import cern.jet.math.Bessel;
import dr.math.GammaFunction;

public class ModifiedBesselFirstKind {
    public static final int ACC = 40;
    public static final int REAL_SUM = 100;
    public static final double BIGNO = 1.0E10;
    public static final double BIGNI = 1.0E-10;

    public static double bessi(double d, int n) {
        if (n == 0) {
            return Bessel.i0(d);
        }
        if (n == 1) {
            return Bessel.i1(d);
        }
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 2.0 / Math.abs(d);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i = 2 * (n + (int)Math.sqrt(40 * n)); i > 0; --i) {
            double d6 = d4 + (double)i * d2 * d5;
            d4 = d5;
            d5 = d6;
            if (Math.abs(d5) > 1.0E10) {
                d3 *= 1.0E-10;
                d5 *= 1.0E-10;
                d4 *= 1.0E-10;
            }
            if (i != n) continue;
            d3 = d4;
        }
        return d < 0.0 && (n & 1) != 0 ? -d3 : (d3 *= Bessel.i0(d) / d5);
    }

    public static double bessi(double d, double d2) {
        double d3 = Math.pow(d / 2.0, d2) / Math.exp(GammaFunction.lnGamma(1.0 + d2));
        return d3 *= ModifiedBesselFirstKind.recurseSum(d, d2);
    }

    private static double recurseSum(double d, double d2) {
        double d3;
        double d4 = d * d / 4.0;
        double d5 = d3 = 1.0;
        for (int i = 1; i < 100; ++i) {
            double d6 = i;
            double d7 = d4 / (d6 * (d6 + d2));
            d5 += (d3 *= d7);
        }
        return d5;
    }

    public static double bessIRatio(double d, double d2, double d3) {
        double d4 = Math.pow(d / d2, d3);
        double d5 = ModifiedBesselFirstKind.recurseSum(d, d3);
        double d6 = ModifiedBesselFirstKind.recurseSum(d2, d3);
        return d4 * d5 / d6;
    }

    public static double scaledBessIRatio(double d, double d2, double d3) {
        double d4 = ModifiedBesselFirstKind.recurseSum(d, d3);
        double d5 = ModifiedBesselFirstKind.recurseSum(d2, d3);
        return d4 / d5;
    }
}

