/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class GeneralizedIntegerGammaDistribution
implements Distribution {
    private int shape1;
    private int shape2;
    private double rate1;
    private double rate2;
    private double[] A = null;
    private double[] B = null;

    public GeneralizedIntegerGammaDistribution(int n, int n2, double d, double d2) {
        this.shape1 = n;
        this.shape2 = n2;
        this.rate1 = d;
        this.rate2 = d2;
    }

    @Override
    public double logPdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public double generatingFunction(double d) {
        return Math.pow(this.rate1 / (this.rate1 + d), this.shape1) * Math.pow(this.rate2 / (this.rate2 + d), this.shape2);
    }

    public double generatingFunctionPartialFraction(double d) {
        int n;
        if (this.A == null) {
            this.computeCoefficients();
        }
        double d2 = 0.0;
        for (n = 1; n <= this.shape1; ++n) {
            d2 += this.A[n] / Math.pow(this.rate1 + d, n);
        }
        for (n = 1; n <= this.shape2; ++n) {
            d2 += this.B[n] / Math.pow(this.rate2 + d, n);
        }
        return d2;
    }

    private void computeCoefficients() {
        int n;
        this.A = new double[this.shape1 + 1];
        this.B = new double[this.shape2 + 1];
        double d = Math.pow(this.rate1, this.shape1) * Math.pow(this.rate2, this.shape2);
        int n2 = 1;
        double d2 = 1.0;
        for (n = 1; n <= this.shape1; ++n) {
            if (n > 1 && this.shape2 + n - 2 > 1) {
                d2 *= (double)(this.shape2 + n - 2);
                d2 /= (double)(n - 1);
            }
            this.A[this.shape1 - n + 1] = d2 * (double)n2 * d / Math.pow(this.rate2 - this.rate1, this.shape2 + n - 1);
            n2 *= -1;
        }
        n2 = 1;
        d2 = 1.0;
        for (n = 1; n <= this.shape2; ++n) {
            if (n > 1 && this.shape1 + n - 2 > 1) {
                d2 *= (double)(this.shape1 + n - 2);
                d2 /= (double)(n - 1);
            }
            this.B[this.shape2 - n + 1] = d2 * (double)n2 * d / Math.pow(this.rate1 - this.rate2, this.shape1 + n - 1);
            n2 *= -1;
        }
    }

    @Override
    public double pdf(double d) {
        int n;
        if (this.A == null) {
            this.computeCoefficients();
        }
        double d2 = Math.exp(-this.rate1 * d);
        double d3 = Math.exp(-this.rate2 * d);
        double d4 = 0.0;
        double d5 = 1.0;
        int n2 = 1;
        for (n = 1; n <= this.shape1; ++n) {
            d4 += this.A[n] * d5 * d2 / (double)n2;
            d5 *= d;
            n2 *= n;
        }
        d5 = 1.0;
        n2 = 1;
        for (n = 1; n <= this.shape2; ++n) {
            d4 += this.B[n] * d5 * d3 / (double)n2;
            d5 *= d;
            n2 *= n;
        }
        return d4;
    }

    public static double pdf(double d, int n, int n2, double d2, double d3) {
        return new GeneralizedIntegerGammaDistribution(n, n2, d2, d3).pdf(d);
    }
}

