/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.iterations.IterativeProcess;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class LargestEigenvalueFinder
extends IterativeProcess {
    private double eigenvalue;
    private Vector eigenvector;
    private Vector transposedEigenvector;
    private Matrix matrix;

    public LargestEigenvalueFinder(double d, Matrix matrix) {
        this(matrix);
        this.setDesiredPrecision(d);
    }

    public LargestEigenvalueFinder(Matrix matrix) {
        this.matrix = matrix;
        this.eigenvalue = Double.NaN;
    }

    public double eigenvalue() {
        return this.eigenvalue;
    }

    public Vector eigenvector() {
        return this.eigenvector.product(1.0 / this.eigenvector.norm());
    }

    @Override
    public double evaluateIteration() {
        double d = this.eigenvalue;
        this.transposedEigenvector = this.transposedEigenvector.secureProduct(this.matrix);
        this.transposedEigenvector = this.transposedEigenvector.product(1.0 / this.transposedEigenvector.components[0]);
        this.eigenvector = this.matrix.secureProduct(this.eigenvector);
        this.eigenvalue = this.eigenvector.components[0];
        this.eigenvector = this.eigenvector.product(1.0 / this.eigenvalue);
        return Double.isNaN(d) ? 10.0 * this.getDesiredPrecision() : Math.abs(this.eigenvalue - d);
    }

    @Override
    public void initializeIterations() {
        int n;
        this.eigenvalue = Double.NaN;
        int n2 = this.matrix.columns();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 1.0;
        }
        this.eigenvector = new Vector(dArray);
        n2 = this.matrix.rows();
        dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 1.0;
        }
        this.transposedEigenvector = new Vector(dArray);
    }

    public LargestEigenvalueFinder nextLargestEigenvalueFinder() {
        double d = 1.0 / this.eigenvector.secureProduct(this.transposedEigenvector);
        Vector vector = this.eigenvector.product(d);
        return new LargestEigenvalueFinder(this.getDesiredPrecision(), this.matrix.secureProduct(SymmetricMatrix.identityMatrix(vector.dimension()).secureSubtract(vector.tensorProduct(this.transposedEigenvector))));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.eigenvalue);
        stringBuffer.append(" (");
        stringBuffer.append(this.eigenvector.toString());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

