/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.oldevomodel.substmodel.Blosum62;
import dr.oldevomodel.substmodel.CPREV;
import dr.oldevomodel.substmodel.Dayhoff;
import dr.oldevomodel.substmodel.EmpiricalRateMatrix;
import dr.oldevomodel.substmodel.FLU;
import dr.oldevomodel.substmodel.JTT;
import dr.oldevomodel.substmodel.LG;
import dr.oldevomodel.substmodel.MTREV;
import dr.oldevomodel.substmodel.WAG;
import dr.util.Citation;

public enum AminoAcidModelType {
    BLOSUM_62("Blosum62", "blosum62", Blosum62.INSTANCE),
    DAYHOFF("Dayhoff", "dayhoff", Dayhoff.INSTANCE),
    JTT("JTT", dr.oldevomodel.substmodel.JTT.INSTANCE),
    MT_REV_24("mtREV", MTREV.INSTANCE),
    CP_REV_45("cpREV", CPREV.INSTANCE),
    WAG("WAG", dr.oldevomodel.substmodel.WAG.INSTANCE),
    LG("LG", dr.oldevomodel.substmodel.LG.INSTANCE),
    FLU("FLU", dr.oldevomodel.substmodel.FLU.INSTANCE);

    private final String displayName;
    private final String xmlName;
    private final EmpiricalRateMatrix matrix;

    private AminoAcidModelType(String string2, EmpiricalRateMatrix empiricalRateMatrix) {
        this(string2, string2, empiricalRateMatrix);
    }

    private AminoAcidModelType(String string2, String string3, EmpiricalRateMatrix empiricalRateMatrix) {
        this.displayName = string2;
        this.xmlName = string3;
        this.matrix = empiricalRateMatrix;
    }

    public String toString() {
        return this.displayName;
    }

    public String getXMLName() {
        return this.xmlName;
    }

    public EmpiricalRateMatrix getRateMatrixInstance() {
        return this.matrix;
    }

    public Citation getCitation() {
        return this.matrix.getCitations().get(0);
    }

    public static String[] xmlNames() {
        AminoAcidModelType[] aminoAcidModelTypeArray = AminoAcidModelType.values();
        String[] stringArray = new String[aminoAcidModelTypeArray.length];
        for (int i = 0; i < aminoAcidModelTypeArray.length; ++i) {
            stringArray[i] = aminoAcidModelTypeArray[i].getXMLName();
        }
        return stringArray;
    }
}

