/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.OnePhaseModel;

public class AsymmetricQuadraticModel
extends OnePhaseModel {
    public static final String ASYMQUAD_MODEL = "ASYMQUADModel";
    private Variable<Double> expanConst;
    private Variable<Double> expanLin;
    private Variable<Double> expanQuad;
    private Variable<Double> contractConst;
    private Variable<Double> contractLin;
    private Variable<Double> contractQuad;

    public AsymmetricQuadraticModel(Microsatellite microsatellite, FrequencyModel frequencyModel) {
        this(microsatellite, frequencyModel, null, null, null, null, null, null, false);
    }

    public AsymmetricQuadraticModel(Microsatellite microsatellite, FrequencyModel frequencyModel, boolean bl) {
        this(microsatellite, frequencyModel, null, null, null, null, null, null, bl);
    }

    public AsymmetricQuadraticModel(Microsatellite microsatellite, FrequencyModel frequencyModel, Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Variable<Double> variable5, Variable<Double> variable6, boolean bl) {
        super(ASYMQUAD_MODEL, microsatellite, frequencyModel, null);
        this.expanConst = this.overrideDefault(new Parameter.Default(1.0), variable);
        this.expanLin = this.overrideDefault(new Parameter.Default(0.0), variable2);
        this.expanQuad = this.overrideDefault(new Parameter.Default(0.0), variable3);
        this.contractConst = this.overrideDefault(this.expanConst, variable4);
        this.contractLin = this.overrideDefault(this.expanLin, variable5);
        this.contractQuad = this.overrideDefault(this.expanQuad, variable6);
        this.isNested = bl;
        this.addParameters();
        this.setupInfinitesimalRates();
        if (frequencyModel == null) {
            this.useStationaryFreqs = true;
            this.computeStationaryDistribution();
        } else {
            this.freqModel = frequencyModel;
        }
        this.addModel(this.freqModel);
    }

    private void addParameters() {
        this.addParam(this.expanConst);
        this.addParam(this.expanLin);
        this.addParam(this.expanQuad);
        if (this.contractConst != this.expanConst) {
            this.addParam(this.contractConst);
        }
        if (this.contractLin != this.expanLin) {
            this.addParam(this.contractLin);
        }
        if (this.contractQuad != this.expanQuad) {
            this.addParam(this.contractQuad);
        }
    }

    private Variable<Double> overrideDefault(Variable<Double> variable, Variable<Double> variable2) {
        if (variable2 != null && variable2 != variable) {
            return variable2;
        }
        return variable;
    }

    @Override
    public void setupInfinitesimalRates() {
        double d = this.expanConst.getValue(0);
        double d2 = this.expanLin.getValue(0);
        double d3 = this.expanQuad.getValue(0);
        double d4 = this.contractConst.getValue(0);
        double d5 = this.contractLin.getValue(0);
        double d6 = this.contractQuad.getValue(0);
        for (int i = 0; i < this.stateCount; ++i) {
            double d7 = 0.0;
            if (i - 1 > -1) {
                this.infinitesimalRateMatrix[i][i - 1] = d4 + d5 * (double)i + d6 * (double)i * (double)i;
                d7 += this.infinitesimalRateMatrix[i][i - 1];
            }
            if (i + 1 < this.stateCount) {
                this.infinitesimalRateMatrix[i][i + 1] = d + d2 * (double)i + d3 * (double)i * (double)i;
                d7 += this.infinitesimalRateMatrix[i][i + 1];
            }
            this.infinitesimalRateMatrix[i][i] = d7 * -1.0;
        }
    }

    public Variable<Double> getExpansionConstant() {
        return this.expanConst;
    }

    public Variable<Double> getExpansionLinear() {
        return this.expanLin;
    }

    public Variable<Double> getExpansionQuad() {
        return this.expanQuad;
    }

    public Variable<Double> getContractionConstant() {
        return this.contractConst;
    }

    public Variable<Double> getContractionLinear() {
        return this.contractLin;
    }

    public Variable<Double> getContractionQuad() {
        return this.contractQuad;
    }

    public void printDetails() {
        System.out.println("\n");
        System.out.println("Details of the asymmetric quadratic model and its parameters:");
        System.out.println("expansion constant:   " + this.expanConst.getValue(0));
        System.out.println("expansion linear:     " + this.expanLin.getValue(0));
        System.out.println("expansion quadratic:  " + this.expanQuad.getValue(0));
        System.out.println("contraction constant: " + this.contractConst.getValue(0));
        System.out.println("contraction linear:   " + this.contractLin.getValue(0));
        System.out.println("contraction quadratc: " + this.contractQuad.getValue(0));
        System.out.println("a submodel:           " + this.isNested);
        System.out.println("\n");
    }
}

