/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import java.util.List;

public class SubstitutionEpochModel
extends AbstractSubstitutionModel {
    public static final boolean DEBUG = false;
    private List<SubstitutionModel> modelList;
    private Parameter transitionTimesParameter;
    private double[] transitionTimes;
    private double[] weight;
    private double[] stepMatrix;
    private double[] productMatrix;
    private double[] resultMatrix;
    private int numberModels;
    private int stateCount;

    public SubstitutionEpochModel(String string, List<SubstitutionModel> list, Parameter parameter, DataType dataType, FrequencyModel frequencyModel) {
        super(string, dataType, frequencyModel);
        this.modelList = list;
        this.transitionTimesParameter = parameter;
        this.transitionTimes = this.transitionTimesParameter.getParameterValues();
        this.addVariable(parameter);
        for (SubstitutionModel substitutionModel : list) {
            this.addModel(substitutionModel);
        }
        this.numberModels = list.size();
        this.weight = new double[this.numberModels];
        this.stateCount = dataType.getStateCount();
        this.stepMatrix = new double[this.stateCount * this.stateCount];
        this.productMatrix = new double[this.stateCount * this.stateCount];
        this.resultMatrix = new double[this.stateCount * this.stateCount];
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.freqModel) {
            this.frequenciesChanged();
        } else {
            this.fireModelChanged(object, n);
        }
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates() {
    }

    public void getTransitionProbabilities(double d, double d2, double d3, double[] dArray) {
        int n = 0;
        boolean bl = this.getEpochWeights(d, d2, this.weight) == 1;
        for (int i = 0; i < this.numberModels; ++i) {
            if (!(this.weight[i] > 0.0)) continue;
            SubstitutionModel substitutionModel = this.modelList.get(i);
            if (n == 0) {
                if (bl) {
                    substitutionModel.getTransitionProbabilities(d3, dArray);
                    break;
                }
                substitutionModel.getTransitionProbabilities(d3 * this.weight[i], this.resultMatrix);
                ++n;
                continue;
            }
            substitutionModel.getTransitionProbabilities(d3 * this.weight[i], this.stepMatrix);
            int n2 = 0;
            for (int j = 0; j < this.stateCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    this.productMatrix[n2] = 0.0;
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        int n3 = n2;
                        this.productMatrix[n3] = this.productMatrix[n3] + this.resultMatrix[j * this.stateCount + i2] * this.stepMatrix[i2 * this.stateCount + k];
                    }
                    ++n2;
                }
            }
            double[] dArray2 = this.resultMatrix;
            this.resultMatrix = this.productMatrix;
            this.productMatrix = dArray2;
        }
        if (!bl) {
            System.arraycopy(this.productMatrix, 0, dArray, 0, this.stateCount * this.stateCount);
        }
    }

    private int getEpochWeights(double d, double d2, double[] dArray) {
        int n = 0;
        double d3 = d2 - d;
        int n2 = this.numberModels - 2;
        if (d <= this.transitionTimes[0]) {
            dArray[0] = d2 <= this.transitionTimes[0] ? 1.0 : (this.transitionTimes[0] - d) / d3;
            ++n;
        } else {
            dArray[0] = 0.0;
        }
        for (int i = 1; i <= n2; ++i) {
            if (d <= this.transitionTimes[i]) {
                double d4 = Math.max(d, this.transitionTimes[i - 1]);
                double d5 = Math.min(d2, this.transitionTimes[i]);
                dArray[i] = (d5 - d4) / d3;
                ++n;
                continue;
            }
            dArray[i] = 0.0;
        }
        if (n2 >= 0) {
            if (d2 > this.transitionTimes[n2]) {
                double d6 = Math.max(d, this.transitionTimes[n2]);
                dArray[n2 + 1] = (d2 - d6) / d3;
                ++n;
            } else {
                dArray[n2 + 1] = 0.0;
            }
        }
        return n;
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        throw new RuntimeException("Should not get here in a substitution epoch model.");
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.transitionTimesParameter) {
            this.transitionTimes = this.transitionTimesParameter.getParameterValues();
            this.fireModelChanged(variable, n);
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }
}

